/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.init.IntentPanel;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JPanel;
import org.apache.commons.io.IOUtils;
import org.limewire.util.CommonUtils;

final class IntentWindow
extends SetupWindow {
    private boolean setWillNot = false;
    private Properties properties;

    IntentWindow(SetupManager manager) {
        super(manager, I18n.tr("State Your Intent"), I18n.tr("One more thing..."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentVersionChecked() {
        String exists;
        if (this.properties == null) {
            this.properties = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.getPropertiesFile());
                this.properties.load(fis);
            }
            catch (IOException iox) {
                boolean bl;
                try {
                    System.out.println("Could not load properties from property file.");
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly(fis);
                return bl;
            }
            IOUtils.closeQuietly(fis);
        }
        return (exists = this.properties.getProperty("willnot")) != null && exists.equals("true");
    }

    boolean isConfirmedWillNot() {
        return this.isCurrentVersionChecked() || this.setWillNot;
    }

    @Override
    protected void createWindow() {
        super.createWindow();
        JPanel innerPanel = new JPanel(new BorderLayout());
        IntentPanel intentPanel = new IntentPanel();
        innerPanel.add((Component)intentPanel, "Center");
        this.setSetupComponent(innerPanel);
        intentPanel.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
        this.setNext(null);
        intentPanel.addButtonListener(e -> {
            if (intentPanel.hasSelection()) {
                this.setNext(this);
                this.setWillNot = intentPanel.isWillNot();
                this._manager.enableActions(this.getAppropriateActions());
            }
        });
    }

    @Override
    public void applySettings(boolean loadCoreComponents) {
        if (this.setWillNot) {
            this.properties.put("willnot", "true");
            try {
                this.properties.store(new FileOutputStream(this.getPropertiesFile()), "Started & Ran Versions");
            }
            catch (IOException ignored) {
                System.out.println(ignored);
            }
        }
    }

    private File getPropertiesFile() {
        return new File(CommonUtils.getUserSettingsDir(), "intent.props");
    }
}

