/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.IconManager;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JLabel;

class TransferVisualizer {
    private static final CellRendererPane PANE = new CellRendererPane();
    private static final int IMAGE_WIDTH = 300;
    private static final int IMAGE_ROW_HEIGHT = 16;
    private final Transferable t;

    TransferVisualizer(Transferable t) {
        this.t = t;
    }

    Image getImage() {
        if (!this.t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return null;
        }
        List l = null;
        try {
            l = (List)this.t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException | IOException ufe) {
            return null;
        }
        if (l.size() == 0) {
            return null;
        }
        int height = 16 * l.size();
        BufferedImage buffer = new BufferedImage(300, height, 2);
        Graphics g = buffer.getGraphics();
        JLabel label = new JLabel();
        label.setVerticalAlignment(1);
        label.setOpaque(false);
        int y = 0;
        for (Object o : l) {
            File f = (File)o;
            Icon icon = IconManager.instance().getIconForFile(f);
            label.setIcon(icon);
            label.setText(f.getName());
            PANE.paintComponent(g, label, null, 0, y, 300, height - y);
            y += 16;
        }
        g.dispose();
        return buffer;
    }
}

