/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

public class MulticastTransferHandler
extends LimeTransferHandler {
    private final ArrayList<LimeTransferHandler> handlers = new ArrayList();
    private LimeTransferHandler lastTransferable;

    public MulticastTransferHandler() {
    }

    public MulticastTransferHandler(LimeTransferHandler handler) {
        this.handlers.add(handler);
    }

    public MulticastTransferHandler(LimeTransferHandler head, Collection<LimeTransferHandler> tail) {
        this.handlers.add(head);
        this.handlers.addAll(tail);
    }

    public MulticastTransferHandler(Collection<LimeTransferHandler> defaultHandlers) {
        this.handlers.addAll(defaultHandlers);
    }

    public void addTransferHandler(LimeTransferHandler handler) {
        this.handlers.add(handler);
    }

    public void removeTransferHandler(LimeTransferHandler handler) {
        this.handlers.remove(handler);
    }

    private LimeTransferHandler[] getHandlers() {
        return this.handlers.toArray(new LimeTransferHandler[0]);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.canImport(c, flavors, ddi)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.canImport(comp, transferFlavors)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            Transferable t = handler.createTransferable(c);
            if (t == null) continue;
            this.lastTransferable = handler;
            return t;
        }
        this.lastTransferable = null;
        return null;
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.importData(c, t, ddi)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        for (LimeTransferHandler handler : this.getHandlers()) {
            if (!handler.importData(comp, t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        int sourceActions = 0;
        for (LimeTransferHandler handler : this.getHandlers()) {
            sourceActions |= handler.getSourceActions(c);
        }
        return sourceActions;
    }

    @Override
    protected void exportDone(JComponent source2, Transferable data, int action) {
        if (this.lastTransferable != null) {
            this.lastTransferable.exportDone(source2, data, action);
            this.lastTransferable = null;
        }
    }
}

