/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDragGestureListener;
import com.limegroup.gnutella.gui.dnd.BasicTransferableCreator;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.TransferVisualizer;
import com.limegroup.gnutella.gui.dnd.TriggerableDragGestureRecognizer;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class LimeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 7753614134944789178L;
    private static TriggerableDragGestureRecognizer recognizer;
    private final int supportedActions;

    protected LimeTransferHandler() {
        this.supportedActions = 0;
    }

    protected LimeTransferHandler(int supportedActions) {
        this.supportedActions = supportedActions;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new BasicTransferableCreator().getTransferable();
    }

    @Override
    protected void exportDone(JComponent source2, Transferable data, int action) {
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.supportedActions;
    }

    @Override
    @Deprecated
    public final Icon getVisualRepresentation(Transferable t) {
        throw new IllegalStateException("USE getImageRepresentation INSTEAD");
    }

    public Image getImageRepresentation(Transferable t) {
        return new TransferVisualizer(t).getImage();
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return false;
    }

    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return false;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        int srcActions = this.getSourceActions(comp);
        int dragAction = srcActions & action;
        if (!(e instanceof MouseEvent)) {
            dragAction = 0;
        }
        if (dragAction != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new TriggerableDragGestureRecognizer(new BasicDragGestureListener());
            }
            recognizer.trigger(comp, (MouseEvent)e, srcActions, dragAction);
        } else {
            this.exportDone(comp, null, 0);
        }
    }
}

