/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;

public class BasicDropTargetListener
implements DropTargetListener {
    private boolean actionSupported(int action) {
        return (action & 3) != 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        DropTargetContext ctx = e.getDropTargetContext();
        JComponent c = (JComponent)ctx.getComponent();
        LimeTransferHandler handler = (LimeTransferHandler)c.getTransferHandler();
        DropDragInfo ddi = new DropDragInfo(e);
        if (handler != null && handler.canImport(c, flavors, ddi) && this.actionSupported(ddi.action)) {
            e.acceptDrag(ddi.action);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        DropTargetContext ctx = e.getDropTargetContext();
        JComponent c = (JComponent)ctx.getComponent();
        LimeTransferHandler handler = (LimeTransferHandler)c.getTransferHandler();
        DropDragInfo ddi = new DropDragInfo(e);
        if (handler != null && handler.canImport(c, flavors, ddi) && this.actionSupported(ddi.action)) {
            e.acceptDrag(ddi.action);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        DropTargetContext ctx = e.getDropTargetContext();
        JComponent c = (JComponent)ctx.getComponent();
        LimeTransferHandler handler = (LimeTransferHandler)c.getTransferHandler();
        DropDragInfo ddi = new DropDragInfo(e);
        if (handler != null && handler.canImport(c, flavors, ddi) && this.actionSupported(ddi.action)) {
            e.acceptDrag(ddi.action);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        DropTargetContext ctx = e.getDropTargetContext();
        JComponent c = (JComponent)ctx.getComponent();
        LimeTransferHandler handler = (LimeTransferHandler)c.getTransferHandler();
        DropDropInfo ddi = new DropDropInfo(e);
        if (handler != null && handler.canImport(c, flavors, ddi) && this.actionSupported(ddi.action)) {
            e.acceptDrop(ddi.action);
            try {
                Transferable t = e.getTransferable();
                e.dropComplete(handler.importData(c, t, ddi));
            }
            catch (RuntimeException re) {
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
    }

    static class DropDragInfo
    implements DropInfo {
        private final DropTargetDragEvent event;
        final int action;

        DropDragInfo(DropTargetDragEvent event) {
            this.event = event;
            this.action = event.getDropAction();
        }

        @Override
        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        @Override
        public Point getPoint() {
            return this.event.getLocation();
        }
    }

    static class DropDropInfo
    implements DropInfo {
        private final DropTargetDropEvent event;
        final int action;

        DropDropInfo(DropTargetDropEvent event) {
            this.event = event;
            this.action = event.getDropAction();
        }

        @Override
        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        @Override
        public Point getPoint() {
            return this.event.getLocation();
        }
    }
}

