/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;

public class SearchAction
extends AbstractAction {
    private final SearchInformation info;

    public SearchAction(String keywords) {
        this(SearchInformation.createKeywordSearch(keywords, null, MediaType.getTorrentMediaType()), I18n.tr("Search for Keywords: {0}"));
    }

    public SearchAction(SearchInformation info, String messageKey) {
        this.info = info;
        this.putValue("Name", MessageFormat.format(I18n.tr(messageKey), info.getTitle()));
        if (SearchMediator.validateInfo(info) != 0) {
            throw new IllegalArgumentException("invalid search info: " + String.valueOf(info));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SearchMediator.instance().triggerSearch(this.info);
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }
}

