/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.BTDownload;
import com.frostwire.gui.tabs.TransfersTab;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MainFrame;
import java.io.File;
import javax.swing.SwingUtilities;

public final class VisualConnectionCallback
implements ActivityCallback {
    private static VisualConnectionCallback INSTANCE;

    private VisualConnectionCallback() {
    }

    public static VisualConnectionCallback instance() {
        if (INSTANCE == null) {
            INSTANCE = new VisualConnectionCallback();
        }
        return INSTANCE;
    }

    @Override
    public void showDownloads() {
        SwingUtilities.invokeLater(() -> GUIMediator.instance().showTransfers(TransfersTab.FilterMode.ALL));
    }

    @Override
    public void restoreApplication() {
        SwingUtilities.invokeLater(GUIMediator::restoreView);
    }

    private MainFrame mf() {
        return GUIMediator.instance().getMainFrame();
    }

    @Override
    public void handleTorrent(File torrentFile) {
        SwingUtilities.invokeLater(() -> GUIMediator.instance().openTorrentFile(torrentFile, false));
    }

    @Override
    public void handleTorrentMagnet(String request, boolean partialDownload) {
        SwingUtilities.invokeLater(() -> {
            GUIMediator.instance().setRemoteDownloadsAllowed(partialDownload);
            System.out.println("VisualConnectionCallback about to call openTorrentURI of request.");
            System.out.println(request);
            GUIMediator.instance().openTorrentURI(request, partialDownload);
        });
    }

    @Override
    public void addDownload(BTDownload dl) {
        AddDownload doWorkRunnable = new AddDownload(dl);
        GUIMediator.safeInvokeLater(doWorkRunnable);
    }

    @Override
    public void updateDownload(BTDownload dl) {
        this.mf().getBTDownloadMediator().updateDownload(dl);
    }

    @Override
    public boolean isRemoteDownloadsAllowed() {
        try {
            SwingUtilities.invokeAndWait(GUIMediator::instance);
        }
        catch (Exception e) {
            System.out.println("Failed to create GUIMediator");
            e.printStackTrace();
        }
        return GUIMediator.instance().isRemoteDownloadsAllowed();
    }

    private class AddDownload
    implements Runnable {
        private final BTDownload mgr;

        AddDownload(BTDownload mgr) {
            this.mgr = mgr;
        }

        @Override
        public void run() {
            VisualConnectionCallback.this.mf().getBTDownloadMediator().addDownload(this.mgr);
        }
    }
}

