/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.ThreadPool;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.VPNs;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class VPNStatusRefresher {
    private static final ThreadPool pool = new ThreadPool("VPNStatusRefresher", 1, 1, Integer.MAX_VALUE, new LinkedBlockingQueue<Runnable>(), true);
    private static VPNStatusRefresher instance;
    private long lastRefresh = 0L;
    private final Set<VPNStatusListener> clients = new HashSet<VPNStatusListener>();
    private boolean active = true;

    private VPNStatusRefresher() {
    }

    public static VPNStatusRefresher getInstance() {
        if (instance == null) {
            instance = new VPNStatusRefresher();
        }
        return instance;
    }

    public void addRefreshListener(VPNStatusListener listener) {
        this.clients.add(listener);
    }

    public void refresh() {
        if (!this.active) {
            return;
        }
        long now = System.currentTimeMillis();
        long REFRESH_INTERVAL_IN_MILLIS = 20000L;
        if (this.lastRefresh == 0L || now - this.lastRefresh >= REFRESH_INTERVAL_IN_MILLIS) {
            this.lastRefresh = now;
            Thread vpnStatusCheckerThread = new Thread("VPNStatus-checker"){

                @Override
                public void run() {
                    if (!VPNStatusRefresher.this.active) {
                        return;
                    }
                    boolean isVPNActive = VPNs.isVPNActive();
                    if (!VPNStatusRefresher.this.active) {
                        return;
                    }
                    GUIMediator.safeInvokeLater(() -> {
                        if (!VPNStatusRefresher.this.active) {
                            return;
                        }
                        for (VPNStatusListener client : VPNStatusRefresher.this.clients) {
                            try {
                                client.onStatusUpdated(isVPNActive);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            };
            vpnStatusCheckerThread.setDaemon(true);
            pool.execute(vpnStatusCheckerThread);
        }
    }

    public void shutdown() {
        this.active = false;
    }

    static interface VPNStatusListener {
        public void onStatusUpdated(boolean var1);
    }
}

