/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class URLLabel
extends JLabel {
    private MouseListener urlListener;
    private PropertyChangeListener listener = null;
    private Action currentAction;
    private String url = "";
    private String text;
    private Color linkColor = UIManager.getColor("Label.foreground");

    public URLLabel(String url) {
        this(url, url);
    }

    public URLLabel(String url, String text) {
        this.url = url;
        this.setText(text);
        this.setToolTipText(url);
        this.installListener(GUIUtils.getURLInputListener(url));
    }

    @Override
    public void setText(String text) {
        this.text = text;
        String htmlString = null;
        if (text != null) {
            htmlString = "<html><a href=\"" + this.url + "\"" + (String)(this.linkColor != null ? "color=\"#" + GUIUtils.colorToHex(this.linkColor) + "\"" : "") + ">" + text + "</a></html>";
        }
        super.setText(htmlString);
    }

    private void setColor(Color fg) {
        this.linkColor = fg;
        this.setText(this.text);
    }

    private Action getAction() {
        return this.currentAction;
    }

    public void setAction(Action action) {
        Action oldAction = this.getAction();
        if (oldAction != null) {
            oldAction.removePropertyChangeListener(this.getListener());
        }
        this.currentAction = action;
        this.currentAction.addPropertyChangeListener(this.getListener());
        this.installListener(GUIUtils.getURLInputListener(action));
        this.updateLabel();
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = evt -> this.updateLabel();
        }
        return this.listener;
    }

    private void updateLabel() {
        if (this.currentAction != null) {
            String display = (String)this.currentAction.getValue("Name");
            Color color = (Color)this.currentAction.getValue("LimeColor");
            if (color != null) {
                this.setColor(color);
            }
            this.setIcon((Icon)this.currentAction.getValue("SmallIcon"));
            this.setToolTipText((String)this.currentAction.getValue("ShortDescription"));
            this.setText(display);
        } else {
            this.setText(this.text);
            this.setToolTipText(this.url);
        }
    }

    private void installListener(MouseListener listener) {
        if (this.urlListener != null) {
            this.removeMouseListener(this.urlListener);
        }
        this.urlListener = listener;
        this.addMouseListener(this.urlListener);
    }
}

