/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

final class StatusComponent
extends JPanel {
    private final JProgressBar BAR;
    private final JLabel LABEL;
    private final boolean STEPPING;
    private final NumberFormat NF;

    public StatusComponent() {
        this.STEPPING = false;
        this.NF = null;
        this.LABEL = new JLabel();
        this.BAR = new JProgressBar();
        this.setLayout(new BoxLayout(this, 1));
        this.construct();
        GUIUtils.setOpaque(false, this);
        if (this.BAR != null && !OSUtils.isMacOSX()) {
            this.BAR.setOpaque(true);
        }
        this.BAR.setIndeterminate(true);
    }

    public StatusComponent(int steps) {
        this.STEPPING = true;
        this.LABEL = new JLabel();
        this.LABEL.setFont(this.LABEL.getFont().deriveFont(1));
        this.BAR = new JProgressBar();
        this.NF = NumberFormat.getInstance(GUIMediator.getLocale());
        this.NF.setMaximumIntegerDigits(3);
        this.NF.setMaximumFractionDigits(0);
        this.setLayout(new BoxLayout(this, 1));
        this.construct();
        GUIUtils.setOpaque(false, this);
        this.BAR.setMaximum(steps + 1);
        this.BAR.setMinimum(0);
        this.BAR.setValue(0);
    }

    public void setProgressPreferredSize(Dimension dim) {
        if (this.BAR != null) {
            this.BAR.setMinimumSize(dim);
            this.BAR.setMaximumSize(dim);
            this.BAR.setPreferredSize(dim);
        }
    }

    public void setText(String text) {
        if (this.STEPPING) {
            this.BAR.setValue(this.BAR.getValue() + 1);
            String percent = this.NF.format((double)this.BAR.getValue() / (double)this.BAR.getMaximum() * 100.0);
            text = percent + "% (" + (String)text + ")";
        }
        if (this.STEPPING || OSUtils.isMacOSX()) {
            this.LABEL.setText((String)text);
        } else {
            this.BAR.setString((String)text);
        }
    }

    private void construct() {
        if (this.STEPPING) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setMinimumSize(new Dimension(400, 340));
            panel.setPreferredSize(new Dimension(400, 340));
            panel.setMaximumSize(new Dimension(400, 340));
            panel.add((Component)this.BAR, "South");
            this.add(panel);
            this.LABEL.setForeground(new Color(4352641));
            this.LABEL.setMinimumSize(new Dimension(400, 20));
            this.LABEL.setPreferredSize(new Dimension(400, 20));
            this.LABEL.setMaximumSize(new Dimension(400, 20));
            this.LABEL.setAlignmentX(0.5f);
            this.LABEL.setFont(this.LABEL.getFont().deriveFont(9.0f));
            this.add(this.LABEL);
        } else {
            this.BAR.setStringPainted(true);
            this.add(this.BAR);
        }
    }
}

