/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Main;
import com.limegroup.gnutella.gui.StatusComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public final class SplashWindow {
    private static SplashWindow INSTANCE;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile StatusComponent glassPane;
    private volatile JWindow splashWindow;

    public static synchronized SplashWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new SplashWindow();
        }
        return INSTANCE;
    }

    static synchronized boolean isSplashConstructed() {
        return INSTANCE != null;
    }

    private void initialize() {
        this.glassPane = new StatusComponent(15);
        JLabel splashLabel = new JLabel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                SplashWindow.this.paintOSIcons(g);
            }
        };
        this.splashWindow = new JWindow();
        this.glassPane.setProgressPreferredSize(new Dimension(400, 17));
        this.glassPane.add(Box.createVerticalGlue(), 0);
        this.glassPane.add(Box.createVerticalStrut(6));
        URL imageURL = null;
        try {
            imageURL = Main.getChosenSplashURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (imageURL != null) {
            BufferedImage splashImage = null;
            try {
                splashImage = ImageIO.read(imageURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (splashImage != null) {
                int imgHeight;
                int imgWidth = ((Image)splashImage).getWidth(null);
                if (imgWidth < 1) {
                    imgWidth = 1;
                }
                if ((imgHeight = ((Image)splashImage).getHeight(null)) < 1) {
                    imgHeight = 1;
                }
                Dimension size = new Dimension(imgWidth + 2, imgHeight + 2);
                this.splashWindow.setSize(size);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.splashWindow.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
                splashLabel.setIcon(new ImageIcon(splashImage));
                this.splashWindow.getContentPane().add((Component)splashLabel, "Center");
                this.splashWindow.setGlassPane(this.glassPane);
                this.splashWindow.pack();
            }
        }
    }

    private void paintOSIcons(Graphics g) {
        try {
            this.paintOSIcon("windows", OSUtils.isWindows(), 10, 10, g);
            this.paintOSIcon("android", false, 43, 10, g);
            this.paintOSIcon("mac", OSUtils.isMacOSX(), 76, 10, g);
            this.paintOSIcon("linux", OSUtils.isLinux(), 109, 10, g);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void paintOSIcon(String osName, boolean on, int x, int y, Graphics g) throws Throwable {
        String prefix = "org/limewire/gui/images/";
        String suffix = "_desktop_splash.png";
        String on_off = on ? "on" : "off";
        URL macIconURL = ClassLoader.getSystemResource(prefix + osName + "_" + on_off + suffix);
        BufferedImage img = ImageIO.read(macIconURL);
        g.drawImage(img, x, y, null);
    }

    public void begin() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.runLater(() -> {
            this.initialize();
            this.splashWindow.toFront();
            this.splashWindow.setVisible(true);
            this.glassPane.setVisible(true);
            this.setStatusText(I18n.tr("Loading FrostWire..."));
        });
    }

    void setStatusText(String text) {
        this.runLater(() -> {
            this.glassPane.setText(text);
            this.glassPane.paintImmediately(0, 0, this.glassPane.getWidth(), this.glassPane.getHeight());
        });
    }

    private void runLater(Runnable runner) {
        if (this.initialized.get()) {
            GUIMediator.safeInvokeAndWait(runner);
        }
    }

    public void dispose() {
        this.runLater(() -> this.splashWindow.dispose());
    }

    public boolean isShowing() {
        return this.splashWindow != null && this.splashWindow.isShowing();
    }

    public void setVisible(boolean b) {
        this.runLater(() -> this.splashWindow.setVisible(b));
    }

    void toBack() {
        this.runLater(() -> this.splashWindow.toBack());
    }
}

