/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.ResourceManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ShutdownWindow
extends JDialog {
    private static final long serialVersionUID = 446845150731872693L;
    private final ImageIcon backgroundImage;

    ShutdownWindow() {
        super(GUIMediator.getAppFrame());
        String image_path = String.format("org/limewire/gui/images/%s.jpg", !OSUtils.isWindowsAppStoreInstall() ? "app_shutdown" : "windows_appstore_install_shutdown");
        this.backgroundImage = ResourceManager.getImageFromResourcePath(image_path);
        final String backgroundUrl = !OSUtils.isWindowsAppStoreInstall() ? "https://www.frostwire.com/android/?from=shutdown" : "https://www.frostwire.com/give/?from=shutdown";
        this.setResizable(false);
        this.setTitle(I18n.tr("Shutting down FrostWire..."));
        this.setDefaultCloseOperation(0);
        JPanel backgroundPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ShutdownWindow.this.backgroundImage.getImage(), 0, 0, null);
            }
        };
        backgroundPanel.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
                GUIMediator.openURL(backgroundUrl);
            }
        });
        backgroundPanel.setLayout(null);
        backgroundPanel.setSize(800, 500);
        this.add(backgroundPanel);
        Insets insets = backgroundPanel.getInsets();
        JLabel label = new JLabel(I18n.tr("Please wait while FrostWire shuts down..."));
        label.setFont(new Font("Dialog", 0, 16));
        Dimension labelPrefSize = label.getPreferredSize();
        backgroundPanel.add(label);
        label.setBounds(65 + insets.left, 400 + insets.top, labelPrefSize.width, labelPrefSize.height);
        LimeJProgressBar bar = new LimeJProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(false);
        backgroundPanel.add(bar);
        bar.setBounds(55 + insets.left, 428 + insets.top, 680, 30);
        this.getContentPane().setPreferredSize(new Dimension(800, 500));
        this.pack();
    }

    public static void main(String[] args2) {
        ShutdownWindow window = new ShutdownWindow();
        window.setVisible(true);
    }
}

