/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.concurrent.concurrent.ThreadExecutor;
import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.UserAgentGenerator;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.bugs.LocalClientInfo;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public class SendFeedbackDialog {
    private static Pattern VALID_EMAIL_ADDRESS_REGEX = null;
    private final JDialog DIALOG;
    private final JTextField emailTextField;
    private final JButton sendButton;
    private final JButton cancelButton;
    private final JTextField userNameTextField;
    private final String FEEDBACK_HINT = I18n.tr("How can we make FrostWire better?") + "\n(" + I18n.tr("Please make sure your firewall or antivirus is not blocking FrostWire") + ")";
    private final JTextArea feedbackTextArea;

    SendFeedbackDialog() {
        this.DIALOG = new JDialog(GUIMediator.getAppFrame());
        this.DIALOG.setModal(true);
        this.DIALOG.setTitle(I18n.tr("Send Feedback"));
        this.DIALOG.setMinimumSize(new Dimension(750, 350));
        this.DIALOG.setResizable(false);
        this.DIALOG.setDefaultCloseOperation(2);
        this.DIALOG.pack();
        JComponent baseContentPane = (JComponent)this.DIALOG.getContentPane();
        GUIUtils.addHideAction(baseContentPane);
        baseContentPane.setLayout(new MigLayout("fill, insets 10 10"));
        baseContentPane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel feedbackPanel = new JPanel(new MigLayout("fill, insets 10 10"));
        this.feedbackTextArea = new JTextArea(this.FEEDBACK_HINT);
        this.feedbackTextArea.selectAll();
        this.feedbackTextArea.setRows(7);
        Dimension feedbackTextAreaDimensions = new Dimension(690, 130);
        this.feedbackTextArea.setMinimumSize(feedbackTextAreaDimensions);
        this.feedbackTextArea.setMaximumSize(feedbackTextAreaDimensions);
        this.feedbackTextArea.setLineWrap(true);
        this.feedbackTextArea.setWrapStyleWord(true);
        this.feedbackTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SendFeedbackDialog.this.onMessageTextAreaFirstClick();
            }
        });
        this.feedbackTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SendFeedbackDialog.this.sendButtonRefresh();
            }
        });
        GUIUtils.fixInputMap(this.feedbackTextArea);
        JScrollPane feedbackTextAreaScrollPane = new JScrollPane(this.feedbackTextArea);
        feedbackTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        feedbackPanel.add((Component)feedbackTextAreaScrollPane, "spanx 2, growx, wrap");
        JPanel contactInfoPanel = new JPanel(new MigLayout("fill, insets 0 0"));
        JLabel emailLabel = new JLabel(I18n.tr("Email (Optional)"));
        emailLabel.setEnabled(false);
        contactInfoPanel.add((Component)emailLabel, "shrink, align left");
        this.emailTextField = new JTextField();
        this.emailTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (SendFeedbackDialog.this.feedbackTextArea.getText().equals(SendFeedbackDialog.this.FEEDBACK_HINT)) {
                    SendFeedbackDialog.this.feedbackTextArea.setText("");
                }
                SendFeedbackDialog.this.sendButtonRefresh();
            }
        });
        contactInfoPanel.add((Component)this.emailTextField, "align left, pushx 1.0, growx");
        JLabel nameLabel = new JLabel(I18n.tr("Your Name (Optional)"));
        nameLabel.setEnabled(false);
        contactInfoPanel.add((Component)nameLabel, "shrink, align left");
        this.userNameTextField = new JTextField();
        this.userNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SendFeedbackDialog.this.feedbackTextArea.getText().equals(SendFeedbackDialog.this.FEEDBACK_HINT)) {
                    SendFeedbackDialog.this.feedbackTextArea.setText("");
                }
            }
        });
        contactInfoPanel.add((Component)this.userNameTextField, "align left, pushx 2.0, growx");
        feedbackPanel.add((Component)contactInfoPanel, "spanx 2, growx, wrap");
        JLabel systemInformationTextArea = new JLabel(SendFeedbackDialog.getSystemInformation(true));
        systemInformationTextArea.setEnabled(false);
        feedbackPanel.add((Component)systemInformationTextArea, "spanx 2, grow, wrap");
        this.sendButton = new JButton(I18n.tr("Send"));
        this.sendButton.addActionListener(e -> this.onSendClicked());
        this.sendButton.setEnabled(false);
        feedbackPanel.add((Component)this.sendButton, "pushx 1.0, alignx right");
        this.cancelButton = new JButton(I18n.tr("Cancel"));
        this.cancelButton.addActionListener(GUIUtils.getDisposeAction());
        feedbackPanel.add((Component)this.cancelButton, "alignx right");
        baseContentPane.add((Component)feedbackPanel, "grow, wrap");
    }

    private static String getSystemInformation(boolean useHTML) {
        LocalClientInfo mock = new LocalClientInfo(new Throwable("mock"), "", "", false);
        String basicSystemInfo = mock.getBasicSystemInfo().sw.toString();
        return useHTML ? "<html>" + basicSystemInfo.replace("\n", "<br/>") + "</html>" : basicSystemInfo;
    }

    public static void main(String[] args2) {
        SendFeedbackDialog sendFeedbackDialog = new SendFeedbackDialog();
        sendFeedbackDialog.showDialog();
    }

    private void sendButtonRefresh() {
        boolean messageLongEnough = this.feedbackTextArea.getText().length() >= 15;
        String emailValue = this.emailTextField.getText().trim();
        boolean validEmailField = emailValue.length() == 0 || this.validateEmail(emailValue);
        this.sendButton.setEnabled(messageLongEnough && validEmailField);
    }

    private boolean validateEmail(String emailString) {
        if (VALID_EMAIL_ADDRESS_REGEX == null) {
            VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{1,6}$", 2);
        }
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailString);
        return matcher.matches();
    }

    private void onMessageTextAreaFirstClick() {
        if (this.feedbackTextArea.getText().equals(this.FEEDBACK_HINT)) {
            this.feedbackTextArea.setText("");
        }
    }

    void showDialog() {
        GUIUtils.centerOnScreen(this.DIALOG);
        this.DIALOG.setVisible(true);
    }

    private void onSendClicked() {
        this.feedbackTextArea.setEnabled(false);
        this.emailTextField.setEnabled(false);
        this.userNameTextField.setEnabled(false);
        this.sendButton.setText(I18n.tr("Sending") + "...");
        this.sendButton.setEnabled(false);
        this.cancelButton.setVisible(false);
        ThreadExecutor.startThread(() -> this.submitFeedbackAsync(this.feedbackTextArea.getText(), this.emailTextField.getText(), this.userNameTextField.getText(), SendFeedbackDialog.getSystemInformation(false)), "submitFeedbackAsync");
        new Timer(800, e -> {
            this.sendButton.setText(I18n.tr("Thank you") + "!");
            new Timer(500, e1 -> this.DIALOG.dispose()).start();
        }).start();
    }

    private void submitFeedbackAsync(String feedback, String email, String name, String systemInfo) {
        HashMap<String, String> feedbackData = new HashMap<String, String>();
        feedbackData.put("feedback", feedback);
        feedbackData.put("email", email);
        feedbackData.put("name", name);
        feedbackData.put("systemInfo", systemInfo);
        HttpClient httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
        try {
            httpClient.post("http://installer.frostwire.com/feedback.php", 10000, UserAgentGenerator.getUserAgent(), feedbackData);
            UISettings.LAST_FEEDBACK_SENT_TIMESTAMP.setValue(System.currentTimeMillis());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

