/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class MultiLineLabel
extends JTextArea {
    private static final int DEFAULT_LABEL_WIDTH = 200;
    private String _theText;
    private ResizeHandler resizeHandler = null;
    private boolean resizable = false;

    public MultiLineLabel(String s) {
        this(s, false);
    }

    public MultiLineLabel(String s, boolean resizable) {
        if (s == null) {
            throw new NullPointerException("null string in MultilineLabel");
        }
        this.setOpaque(false);
        this.setText(s);
        this.resizable = resizable;
    }

    public MultiLineLabel(String s, int pixels) {
        this(s, pixels, false);
    }

    public MultiLineLabel(String s, int pixels, boolean resizable) {
        if (s == null) {
            throw new NullPointerException("null string in MultilineLabel");
        }
        this.setOpaque(false);
        this.setText(s, pixels);
        this.resizable = resizable;
    }

    public MultiLineLabel(String[] strs) {
        this.setOpaque(false);
        this._theText = this.createSizedString(strs);
        super.setText(this._theText);
    }

    public MultiLineLabel(String s, int pixels, int rows, int cols) {
        super(rows, cols);
        if (s == null) {
            throw new NullPointerException("null string in MultilineLabel");
        }
        this.setOpaque(false);
        this.setText(s, pixels);
    }

    private void setText(String s, int pixels) {
        this._theText = s;
        super.setText(this.createSizedString(s, pixels));
    }

    @Override
    public String getText() {
        return this._theText;
    }

    @Override
    public void setText(String s) {
        this._theText = s;
        super.setText(this.createSizedString(s, 200));
    }

    @Override
    public void updateUI() {
        GUIUtils.SizePolicy policy;
        super.updateUI();
        this.setBackground(new Color(255, 255, 255, 0));
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
        if (this.resizeHandler != null) {
            this.resizeHandler.componentResized(null);
        }
        if ((policy = (GUIUtils.SizePolicy)((Object)this.getClientProperty(GUIUtils.SizePolicy.class))) != null) {
            GUIUtils.restrictSize(this, policy);
        }
    }

    private String createSizedString(String message, int pixels) {
        String word;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        StringTokenizer st = new StringTokenizer(message);
        int newWidth = pixels;
        while (st.hasMoreTokens()) {
            word = st.nextToken();
            newWidth = Math.max(newWidth, fm.stringWidth(word));
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder cursb = new StringBuilder();
        st = new StringTokenizer(message, " \n", true);
        while (st.hasMoreTokens()) {
            word = st.nextToken();
            if (word.equals(" ")) continue;
            boolean isNewLine = word.equals("\n");
            if (isNewLine || fm.stringWidth(String.valueOf(cursb) + word) > newWidth) {
                sb.append((CharSequence)cursb);
                sb.append("\n");
                cursb = new StringBuilder();
            }
            if (isNewLine) continue;
            cursb.append(word);
            cursb.append(" ");
        }
        sb.append((CharSequence)cursb);
        return sb.toString();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkAndAddResizeHandler();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Container parent = this.getParent();
        if (this.resizeHandler != null && parent != null) {
            parent.removeComponentListener(this.resizeHandler);
            this.resizeHandler = null;
        }
    }

    private void checkAndAddResizeHandler() {
        Container parent = this.getParent();
        if (parent != null && this.resizable && this.resizeHandler == null) {
            this.resizeHandler = new ResizeHandler();
            parent.addComponentListener(this.resizeHandler);
        }
    }

    private String createSizedString(String[] strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
            sb.append("\n");
        }
        return sb.toString();
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private int lastWidth = -1;

        private ResizeHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int width = MultiLineLabel.this.getSize().width;
            if (width != this.lastWidth) {
                this.lastWidth = width;
                MultiLineLabel.this.setText(MultiLineLabel.this.getText(), MultiLineLabel.this.getSize().width);
            }
        }
    }
}

