/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.tabs.LibraryTab;
import com.frostwire.gui.tabs.SearchTab;
import com.frostwire.gui.tabs.SearchTransfersTab;
import com.frostwire.gui.tabs.Tab;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.gui.updates.UpdateManager;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.ApplicationHeader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.TransferHandlerDropTargetListener;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.limewire.setting.SettingsGroupManager;

public final class MainFrame {
    private final JFrame FRAME;
    private final JPanel TABBED_PANE;
    private BTDownloadMediator BT_DOWNLOAD_MEDIATOR;
    private LibraryMediator LIBRARY_MEDIATOR;
    private OptionsMediator OPTIONS_MEDIATOR;
    private StatusLine STATUS_LINE;
    private final Map<GUIMediator.Tabs, Tab> TABS = new HashMap<GUIMediator.Tabs, Tab>(3);
    private WindowState lastState = null;
    private final ApplicationHeader APPLICATION_HEADER;

    MainFrame(JFrame frame) {
        UpdateManager.scheduleUpdateCheckTask(0);
        this.FRAME = frame;
        new DropTarget(this.FRAME, new TransferHandlerDropTargetListener(DNDUtils.DEFAULT_TRANSFER_HANDLER));
        this.TABBED_PANE = new JPanel(new CardLayout());
        this.TABBED_PANE.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ThemeMediator.LIGHT_BORDER_COLOR));
        this.FRAME.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                MainFrame.this.lastState = new WindowState();
                MainFrame.this.saveWindowState();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MainFrame.this.saveWindowState();
            }
        });
        this.FRAME.addWindowStateListener(e -> this.saveWindowState());
        this.FRAME.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent e) {
                if (!OSUtils.supportsTray() || !ResourceManager.instance().isTrayIconAvailable()) {
                    GUIMediator.restoreView();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.saveWindowState();
                SettingsGroupManager.instance().save();
                GUIMediator.close(true);
            }
        });
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        this.FRAME.setJMenuBar(MenuMediator.instance().getMenuBar());
        JPanel contentPane = new JPanel();
        this.FRAME.setContentPane(contentPane);
        contentPane.setLayout(new MigLayout("insets 0, gap 0"));
        this.buildTabs();
        this.APPLICATION_HEADER = new ApplicationHeader(this.TABS);
        contentPane.add((Component)this.APPLICATION_HEADER, "growx, dock north");
        contentPane.add((Component)this.TABBED_PANE, "wrap");
        contentPane.add((Component)this.getStatusLine().getComponent(), "dock south, shrink 0");
        this.setMinimalSize(this.FRAME, this.APPLICATION_HEADER, this.APPLICATION_HEADER, this.TABBED_PANE, this.getStatusLine().getComponent());
        if (ApplicationSettings.MAGNET_CLIPBOARD_LISTENER.getValue()) {
            this.FRAME.addWindowListener(MagnetClipboardListener.getInstance());
        }
        if (OSUtils.isMacOSX()) {
            this.FRAME.getRootPane().putClientProperty("apple.awt.fullscreenable", true);
        }
    }

    private void setMinimalSize(JFrame frame, JComponent horizontal, JComponent ... verticals) {
        int width = horizontal.getMinimumSize().width;
        int height = 0;
        for (JComponent c : verticals) {
            height += c.getMinimumSize().height;
        }
        frame.setMinimumSize(new Dimension(width, height += 50));
    }

    public ApplicationHeader getApplicationHeader() {
        return this.APPLICATION_HEADER;
    }

    private void saveWindowState() {
        int state = this.FRAME.getExtendedState();
        if (state == 0) {
            Dimension dim = GUIMediator.getAppSize();
            int minAppWidth = ApplicationSettings.APP_WIDTH.getDefaultValue();
            int minAppHeight = ApplicationSettings.APP_HEIGHT.getDefaultValue();
            int appWidth = dim.width;
            int appHeight = dim.height;
            boolean forceMinimumDimensions = false;
            if (appWidth < minAppWidth) {
                appWidth = minAppWidth;
                forceMinimumDimensions = true;
            }
            if (appHeight < minAppHeight) {
                appHeight = minAppHeight;
                forceMinimumDimensions = true;
            }
            if (forceMinimumDimensions) {
                this.FRAME.setSize(new Dimension(appWidth, appHeight));
                this.FRAME.getContentPane().setSize(new Dimension(appWidth, appHeight));
                this.FRAME.getContentPane().setPreferredSize(new Dimension(appWidth, appHeight));
            }
            Point loc = GUIMediator.getAppLocation();
            ApplicationSettings.APP_WIDTH.setValue(appWidth);
            ApplicationSettings.APP_HEIGHT.setValue(appHeight);
            ApplicationSettings.WINDOW_X.setValue(loc.x);
            ApplicationSettings.WINDOW_Y.setValue(loc.y);
            ApplicationSettings.MAXIMIZE_WINDOW.setValue(false);
        } else if ((state & 6) == 6) {
            ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            if (this.lastState != null && this.lastState.time == System.currentTimeMillis()) {
                ApplicationSettings.WINDOW_X.setValue(this.lastState.x);
                ApplicationSettings.WINDOW_Y.setValue(this.lastState.y);
                this.lastState = null;
            }
        }
    }

    private void buildTabs() {
        SearchTab searchTab = new SearchTab();
        TransfersTab transfersTab = new TransfersTab(this.getBTDownloadMediator());
        LibraryTab libraryTab = new LibraryTab(this.getLibraryMediator());
        this.TABS.put(GUIMediator.Tabs.SEARCH, searchTab);
        this.TABS.put(GUIMediator.Tabs.TRANSFERS, transfersTab);
        this.TABS.put(GUIMediator.Tabs.LIBRARY, libraryTab);
        SearchTransfersTab searchTransfers = new SearchTransfersTab(searchTab, transfersTab);
        this.TABS.put(GUIMediator.Tabs.SEARCH_TRANSFERS, searchTransfers);
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        this.addTabs(UISettings.UI_SEARCH_TRANSFERS_SPLIT_VIEW.getValue());
        this.TABBED_PANE.setRequestFocusEnabled(false);
    }

    private void addTabs(boolean useSearchTransfersSplitView) {
        this.TABBED_PANE.removeAll();
        this.updateEnabledTabs(useSearchTransfersSplitView);
        for (GUIMediator.Tabs tabEnum : GUIMediator.Tabs.values()) {
            Tab tab = this.TABS.get((Object)tabEnum);
            if (!tabEnum.isEnabled() || tab == null || tab.getComponent() == null) continue;
            this.addTab(tab);
        }
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.add((Component)tab.getComponent(), tab.getTitle());
    }

    private void updateEnabledTabs(boolean useSearchTransfersSplitView) {
        this.TABBED_PANE.removeAll();
        GUIMediator.Tabs.SEARCH.setEnabled(!useSearchTransfersSplitView);
        GUIMediator.Tabs.TRANSFERS.setEnabled(!useSearchTransfersSplitView);
        GUIMediator.Tabs.SEARCH_TRANSFERS.setEnabled(useSearchTransfersSplitView);
        GUIMediator.Tabs.LIBRARY.setEnabled(true);
    }

    private void setFrameDimensions() {
        int locY;
        int locX;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = Math.min(screenSize.width - insets.left - insets.right, ApplicationSettings.APP_WIDTH.getValue());
        int appHeight = Math.min(screenSize.height - insets.top - insets.bottom, ApplicationSettings.APP_HEIGHT.getValue());
        if (ApplicationSettings.RUN_ONCE.getValue()) {
            locX = Math.max(insets.left, ApplicationSettings.WINDOW_X.getValue());
            locY = Math.max(insets.top, ApplicationSettings.WINDOW_Y.getValue());
        } else {
            locX = (screenSize.width - appWidth) / 2;
            locY = (screenSize.height - appHeight) / 2;
        }
        if (locX + appWidth > screenSize.width) {
            locX = Math.max(insets.left, screenSize.width - insets.left - insets.right - appWidth);
        }
        if (locY + appHeight > screenSize.height) {
            locY = Math.max(insets.top, screenSize.height - insets.top - insets.bottom - appHeight);
        }
        this.FRAME.setLocation(locX, locY);
        this.FRAME.setSize(new Dimension(appWidth, appHeight));
        this.FRAME.getContentPane().setSize(new Dimension(appWidth, appHeight));
        this.FRAME.getContentPane().setPreferredSize(new Dimension(appWidth, appHeight));
        if (ApplicationSettings.MAXIMIZE_WINDOW.getValue() && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.FRAME.setExtendedState(6);
        }
    }

    final BTDownloadMediator getBTDownloadMediator() {
        if (this.BT_DOWNLOAD_MEDIATOR == null) {
            this.BT_DOWNLOAD_MEDIATOR = BTDownloadMediator.instance();
        }
        return this.BT_DOWNLOAD_MEDIATOR;
    }

    private LibraryMediator getLibraryMediator() {
        if (this.LIBRARY_MEDIATOR == null) {
            this.LIBRARY_MEDIATOR = LibraryMediator.instance();
        }
        return this.LIBRARY_MEDIATOR;
    }

    final StatusLine getStatusLine() {
        if (this.STATUS_LINE == null) {
            this.STATUS_LINE = new StatusLine();
        }
        return this.STATUS_LINE;
    }

    final OptionsMediator getOptionsMediator() {
        if (this.OPTIONS_MEDIATOR == null) {
            this.OPTIONS_MEDIATOR = OptionsMediator.instance();
        }
        return this.OPTIONS_MEDIATOR;
    }

    final GUIMediator.Tabs getSelectedTab() {
        Component comp = this.getCurrentTabComponent();
        if (comp != null) {
            for (GUIMediator.Tabs t : this.TABS.keySet()) {
                JComponent tabComponent = this.TABS.get((Object)t).getComponent();
                if (!comp.equals(tabComponent)) continue;
                return t;
            }
        }
        return null;
    }

    void setSelectedTab(GUIMediator.Tabs tab) {
        CardLayout cl = (CardLayout)this.TABBED_PANE.getLayout();
        Tab t = this.TABS.get((Object)tab);
        cl.show(this.TABBED_PANE, t.getTitle());
        this.APPLICATION_HEADER.selectTab(t);
    }

    private Component getCurrentTabComponent() {
        Component currentPanel = null;
        for (Component component : this.TABBED_PANE.getComponents()) {
            if (!component.isVisible()) continue;
            if (component instanceof JPanel) {
                currentPanel = component;
                continue;
            }
            if (!(component instanceof JScrollPane)) continue;
            currentPanel = ((JScrollPane)component).getViewport().getComponent(0);
        }
        return currentPanel;
    }

    final Tab getTab(GUIMediator.Tabs tabs) {
        return this.TABS.get((Object)tabs);
    }

    public void resizeSearchTransferDivider(int newLocation) {
        SearchTransfersTab searchTab = (SearchTransfersTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH_TRANSFERS);
        searchTab.setDividerLocation(newLocation);
    }

    private static class WindowState {
        private final int x = ApplicationSettings.WINDOW_X.getValue();
        private final int y = ApplicationSettings.WINDOW_Y.getValue();
        private final long time = System.currentTimeMillis();

        WindowState() {
        }
    }
}

