/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.jlibtorrent.swig.libtorrent_jni;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.AWTSplashWindow;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;

public class Main {
    private static URL CHOSEN_SPLASH_URL = null;

    public static void main(String[] args2) {
        ThemeMediator.changeTheme();
        System.setProperty("sun.awt.noerasebackground", "true");
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        if (OSUtils.isWindows()) {
            System.setProperty("jlibtorrent.jni.path", Main.getWindowsJLibtorrentPath());
        }
        if (OSUtils.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
            System.setProperty("jlibtorrent.jni.path", Main.getMacOSJLibtorrentPath());
        }
        if (OSUtils.isLinux()) {
            System.setProperty("jlibtorrent.jni.path", Main.getLinuxJLibtorrentPath());
        }
        libtorrent_jni.version();
        Frame splash = null;
        try {
            if (args2 == null || args2.length == 0) {
                splash = Main.showInitialSplash();
            }
            try {
                Class.forName("com.limegroup.gnutella.gui.GUILoader").getMethod("load", String[].class, Frame.class).invoke(null, args2, splash);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Frame showInitialSplash() {
        Frame splashFrame = null;
        BufferedImage image = null;
        URL imageURL = Main.getChosenSplashURL();
        if (imageURL != null) {
            try {
                image = ImageIO.read(imageURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null) {
                splashFrame = AWTSplashWindow.splash(image);
            }
        }
        return splashFrame;
    }

    public static URL getChosenSplashURL() {
        if (CHOSEN_SPLASH_URL != null) {
            return CHOSEN_SPLASH_URL;
        }
        String splashPath = "org/limewire/gui/images/app_splash.jpg";
        CHOSEN_SPLASH_URL = ClassLoader.getSystemResource("org/limewire/gui/images/app_splash.jpg");
        return CHOSEN_SPLASH_URL;
    }

    private static String getWindowsJLibtorrentPath() {
        return Main.getJLibtorrentPath(".dll");
    }

    private static String getMacOSJLibtorrentPath() {
        return Main.getJLibtorrentPath("." + OSUtils.getMacOSArchitecture() + ".dylib");
    }

    private static String getLinuxJLibtorrentPath() {
        return Main.getJLibtorrentPath(".so");
    }

    private static String getJLibtorrentPath(String libraryExtension) {
        boolean isRelease;
        String productionLibPath;
        File fileFromProductionPath;
        String jarPath = new File(FrostWireUtils.getFrostWireJarPath()).getAbsolutePath();
        String libraryName = "libjlibtorrent";
        if (OSUtils.isWindows()) {
            jarPath = jarPath.replaceAll("%20", " ");
            libraryName = "jlibtorrent";
        }
        if ((fileFromProductionPath = new File(productionLibPath = jarPath + File.separator + (String)((isRelease = !jarPath.contains("frostwire" + File.separator + "desktop")) ? libraryName : "lib" + File.separator + "native" + File.separator + libraryName) + libraryExtension)).exists()) {
            System.out.println("Using jlibtorrent (production path): " + fileFromProductionPath.getAbsolutePath());
            return fileFromProductionPath.getAbsolutePath();
        }
        String pathRunningFromCmdLine = jarPath + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "lib" + File.separator + "native" + File.separator + libraryName + libraryExtension;
        File fileFromCMDLine = new File(pathRunningFromCmdLine);
        if (fileFromCMDLine.exists()) {
            System.out.println("Using jlibtorrent (cmd line path): " + fileFromCMDLine.getAbsolutePath());
            return fileFromCMDLine.getAbsolutePath();
        }
        String pathRunningFromIntelliJ = jarPath + File.separator + ".." + File.separator + ".." + File.separator + "lib" + File.separator + "native" + File.separator + libraryName + libraryExtension;
        File fileFromIntelliJProject = new File(pathRunningFromIntelliJ);
        if (fileFromIntelliJProject.exists()) {
            System.out.println("Using jlibtorrent (intellij path): " + fileFromIntelliJProject.getAbsolutePath());
            return fileFromIntelliJProject.getAbsolutePath();
        }
        System.out.println("Using jlibtorrent (fallback): ../../lib/native/" + libraryName + libraryExtension);
        return ".." + File.separator + ".." + File.separator + "lib" + File.separator + "native" + File.separator + libraryName + libraryExtension;
    }
}

