/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListEditor
extends JPanel {
    private static final long serialVersionUID = 5689653237762528073L;
    private static final int DEFAULT_COLUMNS = 10;
    private Vector<String> model;
    private final Vector<ListDataListener> listeners = new Vector();
    private final JTextField editor;
    private final JList<Object> list;
    private DefaultListModel<Object> realModel;
    private final JButton removeButton;

    public ListEditor() {
        this(new Vector<String>());
    }

    private ListEditor(Vector<String> model) {
        this.setLayout(new GridBagLayout());
        this.editor = new LimeTextField("");
        this.editor.setColumns(10);
        this.editor.setPreferredSize(new Dimension(500, 20));
        this.editor.setMaximumSize(new Dimension(500, 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.add((Component)this.editor, gbc);
        AddAction addAction = new AddAction();
        JButton addButton = new JButton(addAction);
        GUIUtils.bindKeyToAction(this.editor, KeyStroke.getKeyStroke(10, 0), addAction);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 6, 0, 0);
        this.add((Component)addButton, gbc);
        RemoveAction removeAction = new RemoveAction();
        this.removeButton = new JButton(removeAction);
        this.removeButton.setEnabled(false);
        gbc.gridwidth = 0;
        this.add((Component)this.removeButton, gbc);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListListener());
        GUIUtils.bindKeyToAction(this.list, KeyStroke.getKeyStroke(127, 0), removeAction);
        JScrollPane scrollPane = new JScrollPane(this.list, 22, 30);
        this.setModel(model);
        scrollPane.setPreferredSize(new Dimension(500, 50));
        scrollPane.setMaximumSize(new Dimension(500, 50));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
    }

    public Vector<String> getModel() {
        return this.model;
    }

    public synchronized void setModel(Vector<String> model) {
        this.model = model;
        this.realModel = new DefaultListModel();
        for (String s : model) {
            this.realModel.addElement(s);
        }
        this.list.setModel(this.realModel);
    }

    private synchronized void removeItem(int i2) {
        this.model.remove(i2);
        this.realModel.remove(i2);
        this.editor.setText("");
        ListDataEvent event = new ListDataEvent(this.model, 2, i2, i2);
        for (ListDataListener listener : this.listeners) {
            listener.intervalRemoved(event);
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 8474390737220207662L;

        AddAction() {
            this.putValue("Name", I18n.tr("Add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = ListEditor.this.editor.getText();
            if (text.trim().equals("")) {
                return;
            }
            int i2 = ListEditor.this.list.getSelectedIndex();
            if (i2 != -1) {
                ListEditor.this.model.setElementAt(text, i2);
                ListEditor.this.realModel.setElementAt(text, i2);
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 0, i2, i2);
                for (ListDataListener listener : ListEditor.this.listeners) {
                    listener.contentsChanged(event);
                }
            } else {
                int last;
                boolean addTail = true;
                if (addTail) {
                    ListEditor.this.model.addElement(text);
                    ListEditor.this.realModel.addElement(text);
                    last = ListEditor.this.model.size() - 1;
                } else {
                    ListEditor.this.model.add(0, text);
                    ListEditor.this.realModel.add(0, text);
                    last = 0;
                }
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 1, last, last);
                for (ListDataListener listener : ListEditor.this.listeners) {
                    listener.intervalAdded(event);
                }
            }
            ListEditor.this.editor.setText("");
            ListEditor.this.list.clearSelection();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 6931596656024307229L;

        RemoveAction() {
            this.putValue("Name", I18n.tr("Remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i2 = ListEditor.this.list.getSelectedIndex();
            if (i2 != -1) {
                ListEditor.this.removeItem(i2);
            }
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ListEditor.this.list.isSelectionEmpty()) {
                ListEditor.this.removeButton.setEnabled(false);
            } else {
                ListEditor.this.removeButton.setEnabled(true);
            }
            Object val = ListEditor.this.list.getSelectedValue();
            if (val != null) {
                ListEditor.this.editor.setText((String)val);
            }
        }
    }
}

