/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LanguageWindow
extends JDialog {
    private static final long serialVersionUID = 1794098818746665242L;
    private static final int MIN_DIALOG_WIDTH = 350;
    private static final String TRANSLATE_URL = "https://github.com/frostwire/frostwire";
    private JCheckBox showLanguageCheckbox;
    private JComboBox<Object> localeComboBox;
    private final JPanel mainPanel;
    private OkayAction okayAction;
    private CancelAction cancelAction;
    private Locale currentLocale = GUIMediator.getLocale();
    private URLLabel helpTranslateLabel;
    private boolean defaultLocaleSelectable;
    private final Font dialogFont;

    public LanguageWindow() {
        super(GUIMediator.getAppFrame());
        this.initializeWindow();
        this.dialogFont = new Font("Dialog", 0, 11);
        Locale[] locales = LanguageUtils.getLocales(this.dialogFont);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.initializeContent(locales);
        this.initializeButtons();
        this.initializeWindow();
        this.updateLabels(this.currentLocale);
        this.pack();
        if (this.getWidth() < 350) {
            this.setSize(350, this.getHeight());
            this.setResizable(false);
        }
    }

    private void initializeWindow() {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        GUIUtils.addHideAction(this);
    }

    private void initializeContent(Locale[] locales) {
        JPanel container = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        DefaultComboBoxModel<Locale> localeModel = new DefaultComboBoxModel<Locale>();
        int selectedScore = -1;
        int selectedIndex = -1;
        Locale systemLocale = Locale.getDefault();
        for (int i2 = 0; i2 < locales.length; ++i2) {
            localeModel.addElement(locales[i2]);
            int score = LanguageUtils.getMatchScore(this.currentLocale, locales[i2]);
            if (score > selectedScore) {
                selectedScore = score;
                selectedIndex = i2;
            }
            if (!locales[i2].equals(systemLocale)) continue;
            this.defaultLocaleSelectable = true;
        }
        this.localeComboBox = new JComboBox(localeModel);
        this.localeComboBox.setFont(this.dialogFont);
        this.localeComboBox.setRenderer(LanguageFlagFactory.getListRenderer());
        this.localeComboBox.setMaximumRowCount(15);
        if (selectedIndex != -1) {
            this.localeComboBox.setSelectedIndex(selectedIndex);
        }
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        container.add(this.localeComboBox, c);
        this.localeComboBox.addItemListener(e -> {
            Locale selected;
            if (e.getStateChange() == 1 && (selected = (Locale)e.getItem()) != null && !this.currentLocale.equals(selected)) {
                this.updateLabels(selected);
                this.showLanguageCheckbox.setSelected(!LanguageUtils.isEnglishLocale(selected));
                this.currentLocale = selected;
            }
        });
        container.add(Box.createVerticalStrut(5), c);
        this.helpTranslateLabel = new URLLabel(TRANSLATE_URL, "");
        this.helpTranslateLabel.setFont(this.dialogFont);
        container.add((Component)this.helpTranslateLabel, c);
        container.add(Box.createVerticalStrut(15), c);
        this.showLanguageCheckbox = new JCheckBox();
        this.showLanguageCheckbox.setFont(this.dialogFont);
        this.showLanguageCheckbox.setSelected(StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.getValue());
        c.anchor = 21;
        container.add((Component)this.showLanguageCheckbox, c);
        container.add(Box.createVerticalStrut(15), c);
        this.mainPanel.add((Component)container, "Center");
    }

    private void initializeButtons() {
        this.okayAction = new OkayAction();
        this.cancelAction = new CancelAction();
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        JButton buttonOK = new JButton(this.okayAction);
        buttonOK.setFont(this.dialogFont);
        buttonPanel.add(buttonOK);
        if (!LanguageUtils.isEnglishLocale(this.currentLocale)) {
            buttonPanel.add(new JButton(new UseEnglishAction()));
        }
        JButton buttonCancel = new JButton(this.cancelAction);
        buttonCancel.setFont(this.dialogFont);
        buttonPanel.add(buttonCancel);
        this.mainPanel.add((Component)buttonPanel, "South");
    }

    private void switchLanguage(Locale locale, boolean showLanguageInStatusBar) {
        if (!this.defaultLocaleSelectable && LanguageUtils.matchesDefaultLocale(locale)) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(GUIMediator.getLocale())) {
            LanguageUtils.setLocale(locale);
            GUIMediator.instance().getStatusLine().updateLanguage();
            String message = I18n.trl("FrostWire must be restarted for the new language to take effect.", locale);
            JLabel labelMessage = new JLabel(message);
            labelMessage.setFont(this.dialogFont);
            JOptionPane.showMessageDialog(this, labelMessage, I18n.tr("Message"), 1);
        }
        StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(showLanguageInStatusBar);
        if (LanguageUtils.isEnglishLocale(locale)) {
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(showLanguageInStatusBar);
        }
        GUIMediator.instance().getStatusLine().refresh();
        this.dispose();
    }

    private void updateLabels(Locale locale) {
        this.setTitle(I18n.trl("Change Language", locale));
        this.okayAction.putValue("Name", I18n.trl("OK", locale));
        this.cancelAction.putValue("Name", I18n.trl("Cancel", locale));
        this.helpTranslateLabel.setText(I18n.trl("Help Translate FrostWire", locale));
        this.showLanguageCheckbox.setText(I18n.trl("Show Language in status bar", locale));
    }

    private class OkayAction
    extends AbstractAction {
        OkayAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Locale locale = (Locale)LanguageWindow.this.localeComboBox.getSelectedItem();
            LanguageWindow.this.switchLanguage(locale, LanguageWindow.this.showLanguageCheckbox.isSelected());
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GUIUtils.getDisposeAction().actionPerformed(event);
        }
    }

    private class UseEnglishAction
    extends AbstractAction {
        UseEnglishAction() {
            this.putValue("Name", "Use English");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            LanguageWindow.this.switchLanguage(Locale.ENGLISH, LanguageWindow.this.showLanguageCheckbox.isSelected());
        }
    }
}

