/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.limewire.util.FileUtils;

public class LanguageUtils {
    private static final String BUNDLE_PREFIX = "org/limewire/i18n/Messages_";
    private static final String BUNDLE_POSTFIX = ".class";
    private static final String BUNDLE_MARKER = "org/limewire/i18n/Messages.class";
    private static final Logger LOG = Logger.getLogger(LanguageUtils.class);

    public static void setLocale(Locale locale) {
        ApplicationSettings.LANGUAGE.setValue(locale.getLanguage());
        ApplicationSettings.COUNTRY.setValue(locale.getCountry());
        ApplicationSettings.LOCALE_VARIANT.setValue(locale.getVariant());
        GUIMediator.resetLocale();
    }

    public static Locale[] getLocales(Font font) {
        LinkedList<Locale> locales = new LinkedList<Locale>();
        File jar = FileUtils.getJarFromClasspath(LanguageUtils.class.getClassLoader(), BUNDLE_MARKER);
        if (jar != null) {
            LanguageUtils.addLocalesFromJar(locales, jar);
        } else {
            LOG.warn("Could not find bundle jar to determine locales");
        }
        locales.sort((o1, o2) -> o1.getDisplayName((Locale)o1).compareToIgnoreCase(o2.getDisplayName((Locale)o2)));
        locales.remove(Locale.ENGLISH);
        locales.add(0, Locale.ENGLISH);
        if (font != null && !OSUtils.isMacOSX()) {
            locales.removeIf(locale -> !GUIUtils.canDisplay(font, locale.getDisplayName((Locale)locale)));
        }
        return locales.toArray(new Locale[0]);
    }

    private static void addLocalesFromJar(List<Locale> locales, File jar) {
        try (ZipFile zip2 = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> entries = zip2.entries();
            while (entries.hasMoreElements()) {
                String iso;
                ArrayList<String> tokens;
                String name = entries.nextElement().getName();
                if (!name.startsWith(BUNDLE_PREFIX) || !name.endsWith(BUNDLE_POSTFIX) || name.contains("$") || (tokens = new ArrayList<String>(Arrays.asList((iso = name.substring(BUNDLE_PREFIX.length(), name.length() - BUNDLE_POSTFIX.length())).split("_", 3)))).size() < 1) continue;
                while (tokens.size() < 3) {
                    tokens.add("");
                }
                String language = (String)tokens.get(0);
                String region = (String)tokens.get(1);
                if (region.length() > 3 || region.length() == 3 && region.matches("[a-zA-Z]+")) {
                    region = "";
                }
                String variant = (String)tokens.get(2);
                LOG.info("LanguageUtils.addLocalesFromJar: name=%s, language=%s, region=%s, variant=%s".formatted(name, language, region, variant));
                Locale locale = new Locale.Builder().setLanguage(language).setRegion(region).setVariant(variant).build();
                locales.add(locale);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not determine locales", e);
        }
    }

    static boolean isEnglishLocale(Locale locale) {
        return Locale.ENGLISH.getLanguage().equals(locale.getLanguage());
    }

    static int getMatchScore(Locale specificLocale, Locale genericLocale) {
        int i2 = 0;
        if (specificLocale.getLanguage().equals(genericLocale.getLanguage())) {
            ++i2;
        } else if (genericLocale.getLanguage().length() > 0) {
            return -1;
        }
        if (specificLocale.getCountry().equals(genericLocale.getCountry())) {
            ++i2;
        } else if (genericLocale.getCountry().length() > 0) {
            return -1;
        }
        if (specificLocale.getVariant().equals(genericLocale.getVariant())) {
            ++i2;
        } else if (genericLocale.getVariant().length() > 0) {
            return -1;
        }
        return i2;
    }

    static boolean matchesDefaultLocale(Locale locale) {
        Locale systemLocale = Locale.getDefault();
        return LanguageUtils.matchesOrIsMoreSpecific(systemLocale.getLanguage(), locale.getLanguage()) && LanguageUtils.matchesOrIsMoreSpecific(systemLocale.getCountry(), locale.getCountry()) && LanguageUtils.matchesOrIsMoreSpecific(systemLocale.getVariant(), locale.getVariant());
    }

    private static boolean matchesOrIsMoreSpecific(String detailed, String generic) {
        return generic.length() == 0 || detailed.equals(generic);
    }
}

