/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.BTContext;
import com.frostwire.bittorrent.BTEngine;
import com.frostwire.service.ErrorService;
import com.frostwire.service.MessageService;
import com.frostwire.util.OSUtils;
import com.frostwire.util.UserAgentGenerator;
import com.limegroup.gnutella.ExternalControl;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.gui.DeadlockSupport;
import com.limegroup.gnutella.gui.DefaultErrorCatcher;
import com.limegroup.gnutella.gui.ErrorHandler;
import com.limegroup.gnutella.gui.FirewallUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GURLHandler;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LimeWireGUI;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MessageHandler;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SettingsWarningManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.VPNDropGuard;
import com.limegroup.gnutella.gui.VPNStatusRefresher;
import com.limegroup.gnutella.gui.bugs.BugManager;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicHTML;
import org.limewire.util.CommonUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.NetworkUtils;

final class Initializer {
    private volatile boolean isStartup = false;

    Initializer() {
    }

    void initialize(String[] args2, Frame awtSplash) {
        this.preinit();
        this.setupCallbacksAndListeners();
        this.validateStartup(args2);
        LimeWireGUI limewireGUI = this.createLimeWire();
        LimeWireCore limeWireCore = limewireGUI.getLimeWireCore();
        this.glueCore(limeWireCore);
        this.runExternalChecks(limeWireCore, args2);
        limeWireCore.getExternalControl().startServer();
        DeadlockSupport.startDeadlockMonitoring();
        this.installProperties();
        this.installResources();
        SetupManager setupManager = new SetupManager();
        this.switchSplashes(awtSplash);
        this.startEarlyCore(limeWireCore);
        this.initializeEarlyUI();
        this.startSetupManager(setupManager);
        this.startBittorrentCore();
        this.loadUI();
        this.loadTrayAndNotifications();
        this.hideSplashAndShowUI();
        this.loadLateTasksForUI();
        this.startCore(limeWireCore);
        this.runQueuedRequests(limeWireCore);
        if (OSUtils.isMacOSX()) {
            GURLHandler.getInstance().register();
            MacEventHandler.instance();
        }
        this.postinit();
    }

    private void preinit() {
        try {
            LimeCoreGlue.preinstall();
        }
        catch (LimeCoreGlue.InstallFailedException ife) {
            this.failPreferencesPermissions();
        }
    }

    private void setupCallbacksAndListeners() {
        ErrorService.setErrorCallback(new ErrorHandler());
        MessageService.setCallback(new MessageHandler());
        DefaultErrorCatcher.install();
    }

    private void validateStartup(String[] args2) {
        if (StartupSettings.RUN_ON_STARTUP.getValue()) {
            Thread.yield();
        }
        if (OSUtils.isMacOSX()) {
            try {
                MacOSXUtils.setLoginStatus(StartupSettings.RUN_ON_STARTUP.getValue());
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        if (args2.length >= 1 && "-startup".equals(args2[0])) {
            this.isStartup = true;
        }
        if (this.isStartup && !StartupSettings.RUN_ON_STARTUP.getValue()) {
            System.exit(0);
        }
    }

    private LimeWireGUI createLimeWire() {
        return LimeWireModule.instance().getLimeWireGUIModule().getLimeWireGUI();
    }

    private void glueCore(LimeWireCore limeWireCore) {
        limeWireCore.getLimeCoreGlue().install();
    }

    private void runExternalChecks(LimeWireCore limeWireCore, String[] args2) {
        ExternalControl externalControl = limeWireCore.getExternalControl();
        if (args2.length > 0 && !args2[0].equals("-startup")) {
            String arg = externalControl.preprocessArgs(args2);
            externalControl.checkForActiveFrostWire(arg);
            externalControl.enqueueControlRequest(arg);
        } else if (!StartupSettings.ALLOW_MULTIPLE_INSTANCES.getValue()) {
            externalControl.checkForActiveFrostWire();
        }
    }

    private void installProperties() {
        System.setProperty("http.agent", UserAgentGenerator.getUserAgent());
        if (OSUtils.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }

    private void installResources() {
        GUIMediator.safeInvokeAndWait(ResourceManager::instance);
    }

    private void startEarlyCore(LimeWireCore limeWireCore) {
        boolean inFirewallException = FirewallUtils.addToFirewall();
        if (!inFirewallException) {
            limeWireCore.getLifecycleManager().loadBackgroundTasks();
        }
    }

    private void switchSplashes(Frame awtSplash) {
        GUIMediator.safeInvokeAndWait(() -> {
            if (!this.isStartup) {
                SplashWindow.instance().begin();
            }
        });
        if (awtSplash != null) {
            awtSplash.dispose();
        }
    }

    private void initializeEarlyUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading HTML Engine..."));
        GUIMediator.safeInvokeAndWait(() -> {
            JLabel label = new JLabel();
            label.setFont(null);
            label.setForeground(null);
            BasicHTML.createHTMLView(label, "<html>.</html>");
        });
        BugManager.instance();
    }

    private void startSetupManager(SetupManager setupManager) {
        GUIMediator.safeInvokeAndWait(setupManager::createIfNeeded);
    }

    private void loadUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading User Interface..."));
        GUIMediator.safeInvokeAndWait(GUIMediator::instance);
        GUIMediator.setSplashScreenString(I18n.tr("Loading Core Components..."));
    }

    private void loadTrayAndNotifications() {
        GUIMediator.safeInvokeAndWait(() -> {
            NotifyUserProxy.instance();
            if (!ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                NotifyUserProxy.instance().hideTrayIcon();
            }
            SettingsWarningManager.checkSettingsLoadSaveFailure();
        });
    }

    private void hideSplashAndShowUI() {
        if (!this.isStartup) {
            SplashWindow.instance().dispose();
        }
        GUIMediator.allowVisibility();
        if (!this.isStartup) {
            GUIMediator.setAppVisible(true);
        } else {
            GUIMediator.startupHidden();
        }
    }

    private void loadLateTasksForUI() {
        GUIMediator.safeInvokeAndWait(() -> {
            GUIMediator.setSplashScreenString(I18n.tr("Loading Icons..."));
            IconManager.instance();
        });
        GUIMediator.setSplashScreenString(I18n.tr("Loading Internationalization Support..."));
        I18NConvert.instance();
    }

    private void startCore(LimeWireCore limeWireCore) {
        limeWireCore.getLifecycleManager().start();
        GUIMediator.instance().coreInitialized();
        GUIMediator.setSplashScreenString(I18n.tr("Loading Old Downloads..."));
        limeWireCore.getDownloadManager().loadSavedDownloadsAndScheduleWriting();
    }

    private void startBittorrentCore() {
        SharingSettings.initTorrentDataDirSetting();
        SharingSettings.initTorrentsDirSetting();
        File homeDir = new File(String.valueOf(CommonUtils.getUserSettingsDir()) + File.separator + "libtorrent" + File.separator);
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        int randomPortInRange = NetworkUtils.getPortInRange(ConnectionSettings.MANUAL_PORT_RANGE.getValue(), ConnectionSettings.PORT_RANGE_0.getDefaultValue(), ConnectionSettings.PORT_RANGE_1.getDefaultValue(), ConnectionSettings.PORT_RANGE_0.getValue(), ConnectionSettings.PORT_RANGE_1.getValue());
        String iface = NetworkUtils.getLibtorrentFormattedNetworkInterface(ConnectionSettings.USE_CUSTOM_NETWORK_INTERFACE.getValue(), "0.0.0.0", ConnectionSettings.CUSTOM_INETADRESS_NO_PORT.getValue(), randomPortInRange);
        BTContext ctx = new BTContext();
        ctx.homeDir = homeDir;
        ctx.torrentsDir = SharingSettings.TORRENTS_DIR_SETTING.getValue();
        ctx.dataDir = SharingSettings.TORRENT_DATA_DIR_SETTING.getValue();
        ctx.interfaces = iface;
        ctx.retries = 10;
        ctx.enableDht = SharingSettings.ENABLE_DISTRIBUTED_HASH_TABLE.getValue();
        FrostWireUtils.getFrostWireVersionBuild(ctx.version);
        BTEngine.ctx = ctx;
        BTEngine.onCtxSetupComplete();
        BTEngine btEngine = BTEngine.getInstance();
        btEngine.start();
        VPNStatusRefresher.getInstance().addRefreshListener(new VPNDropGuard());
    }

    private void runQueuedRequests(LimeWireCore limeWireCore) {
        limeWireCore.getExternalControl().runQueuedControlRequest();
    }

    private void postinit() {
        GUIMediator.instance().loadFinished();
    }

    private void failPreferencesPermissions() {
        this.fail(I18n.tr("FrostWire could not create a temporary preferences folder.\n\nThis is generally caused by a lack of permissions.  Please make sure that FrostWire (and you) have access to create files/folders on your computer.  If the problem persists, please visit www.frostwire.com and click the 'Support' link.\n\nFrostWire will now exit.  Thank You."));
    }

    private void fail(String msgKey) {
        try {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, new MultiLineLabel(I18n.tr(msgKey), 400), I18n.tr("Error"), 0));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        System.exit(1);
    }
}

