/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.BasicFileIconController;
import com.limegroup.gnutella.gui.ButtonIconController;
import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.NativeFileIconController;
import java.io.File;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class IconManager {
    private static volatile IconManager INSTANCE;
    private FileIconController fileController;
    private final ButtonIconController buttonController = new ButtonIconController();

    private IconManager() {
        this.fileController = new BasicFileIconController();
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            SwingUtilities.invokeLater(() -> {
                NativeFileIconController newController = new NativeFileIconController();
                if (newController.isValid()) {
                    this.fileController = newController;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IconManager instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<IconManager> clazz = IconManager.class;
        synchronized (IconManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new IconManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Icon getIconForFile(File f) {
        String ext;
        this.validate();
        String string = ext = f != null ? FilenameUtils.getExtension(f.getName()) : null;
        if (f != null && ext != null && ext.toLowerCase().endsWith("torrent")) {
            return GUIMediator.getThemeImage("frosthires");
        }
        return this.fileController.getIconForFile(f);
    }

    public Icon getIconForExtension(String ext) {
        this.validate();
        if (ext != null && ext.toLowerCase().endsWith("torrent")) {
            return GUIMediator.getThemeImage("frosthires");
        }
        return this.fileController.getIconForExtension(ext);
    }

    public boolean isIconForFileAvailable(File f) {
        this.validate();
        return this.fileController.isIconForFileAvailable(f);
    }

    void wipeButtonIconCache() {
        this.buttonController.wipeButtonIconCache();
    }

    public Icon getIconForButton(String buttonName) {
        return this.buttonController.getIconForButton(buttonName);
    }

    Icon getRolloverIconForButton(String buttonName) {
        return this.buttonController.getRolloverIconForButton(buttonName);
    }

    private void validate() {
        if (!this.fileController.isValid()) {
            this.fileController = new BasicFileIconController();
        }
    }
}

