/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.service.ErrorService;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;

public final class GURLHandler {
    private static final Logger LOG = Logger.getLogger(GURLHandler.class);
    private static GURLHandler instance;
    private volatile boolean registered = false;

    public static synchronized GURLHandler getInstance() {
        if (instance == null) {
            instance = new GURLHandler();
        }
        return instance;
    }

    public void register() {
        if (!this.registered) {
            int error = this.InstallEventHandler();
            if (error == 0) {
                LOG.info("GURLHandler.register() AppleEvent handler registered");
                this.registered = true;
            } else {
                LOG.error("GURLHandler.register() AppleEvent handler not registered, error " + error);
            }
        }
    }

    private void callback(String uri) {
        LOG.debug("URI: " + uri);
        if (uri.startsWith("magnet:?xt=urn:btih")) {
            GUIMediator.instance().openTorrentURI(uri, false);
        }
    }

    private synchronized native int InstallEventHandler();

    static {
        try {
            System.loadLibrary("GURL");
        }
        catch (Throwable err) {
            ErrorService.error(err);
        }
    }
}

