/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.gui.GUIConstants;
import org.limewire.util.SystemUtils;

class FirewallUtils {
    FirewallUtils() {
    }

    static boolean addToFirewall() {
        if (!OSUtils.isWindows()) {
            return false;
        }
        String path = SystemUtils.getRunningPath();
        if (path == null) {
            return false;
        }
        if (!path.equalsIgnoreCase(GUIConstants.FROSTWIRE_EXE_FILE.getAbsolutePath())) {
            return false;
        }
        if (SystemUtils.isProgramListedOnFirewall(path)) {
            return true;
        }
        if (SystemUtils.addProgramToFirewall(path, "FrostWire")) {
            FirewallUtils.scheduleRemovalOnShutdown();
            return true;
        }
        return false;
    }

    private static void removeFromFirewall() {
        if (!OSUtils.isWindows()) {
            return;
        }
        String path = SystemUtils.getRunningPath();
        if (path == null || !path.equalsIgnoreCase(GUIConstants.FROSTWIRE_EXE_FILE.getPath())) {
            return;
        }
        if (SystemUtils.isProgramListedOnFirewall(path)) {
            SystemUtils.removeProgramFromFirewall(path);
        }
    }

    private static void scheduleRemovalOnShutdown() {
        Thread waiter = new Thread("Platform Firewall Waiter"){

            @Override
            public void run() {
                FirewallUtils.removeFromFirewall();
            }
        };
        LimeWireCore.instance().getLifecycleManager().addShutdownItem(waiter);
    }
}

