/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.CommonUtils;

public final class FileChooserHandler {
    private FileChooserHandler() {
    }

    public static File getLastInputDirectory() {
        File dir = ApplicationSettings.LAST_FILECHOOSER_DIRECTORY.getValue();
        if (dir == null || dir.getPath().equals("") || !dir.exists() || !dir.isDirectory()) {
            return CommonUtils.getCurrentDirectory();
        }
        return dir;
    }

    public static void setLastInputDirectory(File file) {
        if (file != null) {
            if (!file.exists() || !file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null && file.exists() && file.isDirectory()) {
                ApplicationSettings.LAST_FILECHOOSER_DIRECTORY.setValue(file);
            }
        }
    }

    public static File getInputDirectory(Component parent) {
        return FileChooserHandler.getInputDirectory(parent, I18n.tr("Select Folder"), FileChooserHandler.getLastInputDirectory());
    }

    private static File getInputDirectory(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, I18n.tr("Select"), directory);
    }

    private static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, approveKey, directory, null);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        List<File> dirs = FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 1, 0, false, filter);
        assert (dirs == null || dirs.size() <= 1) : "selected more than one folder: " + String.valueOf(dirs);
        if (dirs != null && dirs.size() == 1) {
            return dirs.get(0);
        }
        return null;
    }

    public static File getInputFile(Component parent, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, I18n.tr("Select Folder"), I18n.tr("Select"), FileChooserHandler.getLastInputDirectory(), filter);
    }

    public static File getInputFile(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, titleKey, I18n.tr("Select"), directory, filter);
    }

    private static File getInputFile(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        List<File> files = FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0, false, filter);
        assert (files == null || files.size() <= 1) : "selected more than one folder: " + String.valueOf(files);
        if (files != null && files.size() == 1) {
            return files.get(0);
        }
        return null;
    }

    public static File getSaveAsFile(String titleKey, File suggestedFile, FileFilter filter) {
        FileDialog dialog = new FileDialog((Frame)GUIMediator.getAppFrame(), I18n.tr(titleKey), 1);
        dialog.setDirectory(suggestedFile.getParent());
        dialog.setFile(suggestedFile.getName());
        if (filter != null) {
            FilenameFilter f = (dir, name) -> filter.accept(new File(dir, name));
            dialog.setFilenameFilter(f);
        }
        dialog.setVisible(true);
        String dir2 = dialog.getDirectory();
        Object file = dialog.getFile();
        if (dir2 != null && file != null) {
            if (suggestedFile != null) {
                String suggestedFileExtension = FilenameUtils.getExtension(suggestedFile.getName());
                String newFileExtension = FilenameUtils.getExtension((String)file);
                if (newFileExtension == null && suggestedFileExtension != null) {
                    file = (String)file + "." + suggestedFileExtension;
                }
            }
            File f = new File(dir2, (String)file);
            if (filter != null && !filter.accept(f)) {
                return null;
            }
            FileChooserHandler.setLastInputDirectory(new File(dir2));
            return f;
        }
        return null;
    }

    public static File getSaveAsDir(Component parent, String titleKey, File suggestedFile) {
        return FileChooserHandler.getSaveAsDir(parent, titleKey, suggestedFile, null);
    }

    private static File getSaveAsDir(Component parent, String titleKey, File suggestedFile, FileFilter filter) {
        if (OSUtils.isAnyMac()) {
            FileDialog dialog = new FileDialog((Frame)GUIMediator.getAppFrame(), I18n.tr(titleKey), 1);
            dialog.setDirectory(suggestedFile.getParent());
            dialog.setFile(suggestedFile.getName());
            if (filter != null) {
                FilenameFilter f = (dir, name) -> filter.accept(new File(dir, name));
                dialog.setFilenameFilter(f);
            }
            dialog.setVisible(true);
            String dir2 = dialog.getDirectory();
            FileChooserHandler.setLastInputDirectory(new File(dir2));
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (dir2 != null) {
                File f = new File(dir2);
                if (filter != null && !filter.accept(f)) {
                    return null;
                }
                return f;
            }
            return null;
        }
        JFileChooser chooser = FileChooserHandler.getDirectoryChooser(titleKey, null, null, 1, filter);
        chooser.setSelectedFile(suggestedFile);
        int ret = chooser.showSaveDialog(parent);
        File file = chooser.getSelectedFile();
        FileChooserHandler.setLastInputDirectory(file);
        return ret != 0 ? null : file;
    }

    private static List<File> getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option, boolean allowMultiSelect, FileFilter filter) {
        if (mode == 1 && !OSUtils.isAnyMac()) {
            JFileChooser fileChooser = FileChooserHandler.getDirectoryChooser(titleKey, approveKey, directory, mode, filter);
            fileChooser.setMultiSelectionEnabled(allowMultiSelect);
            try {
                if (fileChooser.showOpenDialog(parent) != option) {
                    return null;
                }
            }
            catch (NullPointerException npe) {
                return null;
            }
            if (allowMultiSelect) {
                File[] chosen = fileChooser.getSelectedFiles();
                if (chosen.length > 0) {
                    FileChooserHandler.setLastInputDirectory(chosen[0]);
                }
                return Arrays.asList(chosen);
            }
            File chosen = fileChooser.getSelectedFile();
            FileChooserHandler.setLastInputDirectory(chosen);
            return Collections.singletonList(chosen);
        }
        if (mode == 1) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        FileDialog dialog = new FileDialog((Frame)GUIMediator.getAppFrame(), "");
        dialog.setTitle(I18n.tr(titleKey));
        if (filter != null) {
            FilenameFilter f = (dir, name) -> {
                if (mode == 1) {
                    return new File(dir, name).isDirectory();
                }
                return filter.accept(new File(dir, name));
            };
            dialog.setFilenameFilter(f);
        }
        if (directory != null) {
            dialog.setDirectory(directory.getAbsolutePath());
        }
        dialog.setVisible(true);
        String dirStr = dialog.getDirectory();
        String fileStr = dialog.getFile();
        if (mode == 1) {
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        }
        if (dirStr == null || fileStr == null) {
            return null;
        }
        FileChooserHandler.setLastInputDirectory(new File(dirStr));
        File f = new File(dirStr, fileStr);
        if (filter != null && !filter.accept(f)) {
            return null;
        }
        return Collections.singletonList(f);
    }

    private static JFileChooser getDirectoryChooser(String titleKey, String approveKey, File directory, int mode, FileFilter filter) {
        JFileChooser chooser;
        if (directory == null) {
            directory = FileChooserHandler.getLastInputDirectory();
        }
        if (directory == null) {
            chooser = new JFileChooser();
        } else {
            try {
                chooser = new JFileChooser(directory);
            }
            catch (NullPointerException e) {
                try {
                    chooser = new JFileChooser(directory);
                }
                catch (NullPointerException npe) {
                    UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
                    chooser = new JFileChooser(directory);
                }
            }
            catch (ArrayIndexOutOfBoundsException ie) {
                chooser = new JFileChooser(directory);
            }
        }
        FileChooserHandler.prepareForWindowEvents(chooser);
        if (filter != null) {
            chooser.setFileFilter(filter);
        } else if (mode == 1) {
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return true;
                }

                @Override
                public String getDescription() {
                    return I18n.tr("All Folders");
                }
            });
        }
        chooser.setFileSelectionMode(mode);
        String title = I18n.tr(titleKey);
        chooser.setDialogTitle(title);
        if (approveKey != null) {
            String approveButtonText = I18n.tr(approveKey);
            chooser.setApproveButtonText(approveButtonText);
        }
        return chooser;
    }

    private static void prepareForWindowEvents(JFileChooser fileChooser) {
        fileChooser.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FileChooserHandler.onFileChooserResized(e.getComponent().getSize().width, e.getComponent().getSize().height);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                FileChooserHandler.onFileChooserMoved(e.getComponent().getX(), e.getComponent().getY());
            }
        });
        if (ApplicationSettings.FILECHOOSER_X_POS.getValue() == -1) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ApplicationSettings.FILECHOOSER_X_POS.setValue(screenSize.width - ApplicationSettings.FILECHOOSER_WIDTH.getValue() >> 1);
            ApplicationSettings.FILECHOOSER_Y_POS.setValue(screenSize.height - ApplicationSettings.FILECHOOSER_HEIGHT.getValue() >> 1);
        }
        fileChooser.setLocation(ApplicationSettings.FILECHOOSER_X_POS.getValue(), ApplicationSettings.FILECHOOSER_Y_POS.getValue());
        fileChooser.setPreferredSize(new Dimension(ApplicationSettings.FILECHOOSER_WIDTH.getValue(), ApplicationSettings.FILECHOOSER_HEIGHT.getValue()));
    }

    private static void onFileChooserResized(int width, int height) {
        ApplicationSettings.FILECHOOSER_WIDTH.setValue(width);
        ApplicationSettings.FILECHOOSER_HEIGHT.setValue(height);
    }

    private static void onFileChooserMoved(int x, int y) {
        ApplicationSettings.FILECHOOSER_X_POS.setValue(x);
        ApplicationSettings.FILECHOOSER_Y_POS.setValue(y);
    }
}

