/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.IllegalComponentStateException;

class DefaultErrorCatcher {
    DefaultErrorCatcher() {
    }

    static void install() {
        System.setProperty("sun.awt.exception.handler", DefaultErrorCatcher.class.getName());
    }

    private boolean isIgnorable(Throwable bug, String msg) {
        if (bug instanceof StackOverflowError) {
            return true;
        }
        if (bug instanceof OutOfMemoryError) {
            return true;
        }
        if (msg == null) {
            return true;
        }
        if (msg.contains("javax.swing.RepaintManager")) {
            return true;
        }
        if (msg.contains("sun.awt.RepaintArea.paint")) {
            return true;
        }
        if (bug instanceof ArrayIndexOutOfBoundsException) {
            if (msg.contains("apple.awt.CWindow.displayChanged")) {
                return true;
            }
            if (msg.contains("javax.swing.plaf.basic.BasicTabbedPaneUI.getTabBounds")) {
                return true;
            }
        }
        if (bug instanceof IllegalStateException && msg.contains("cannot open system clipboard")) {
            return true;
        }
        if (bug instanceof IllegalComponentStateException && msg.contains("component must be showing on the screen to determine its location")) {
            return true;
        }
        if (bug instanceof NullPointerException) {
            if (msg.contains("MetalFileChooserUI")) {
                return true;
            }
            if (msg.contains("WindowsFileChooserUI")) {
                return true;
            }
            if (msg.contains("AquaDirectoryModel")) {
                return true;
            }
            if (msg.contains("SizeRequirements.calculateAlignedPositions")) {
                return true;
            }
            if (msg.contains("BasicTextUI.damageRange")) {
                return true;
            }
            if (msg.contains("null pData")) {
                return true;
            }
            if (msg.contains("disposed component")) {
                return true;
            }
            if (msg.contains("javax.swing.JComponent.repaint") && msg.contains("com.limegroup.gnutella.gui.FileChooserHandler.getSaveAsFile")) {
                return true;
            }
            if (msg.contains("javax.swing.JComponent.repaint") && msg.contains("com.limegroup.gnutella.gui.FileChooserHandler.getInput")) {
                return true;
            }
        }
        if (bug instanceof IndexOutOfBoundsException) {
            if (msg.contains("Invalid index") && msg.contains("com.limegroup.gnutella.gui.FileChooserHandler.getSaveAsFile")) {
                return true;
            }
            if (msg.contains("Invalid index") && msg.contains("com.limegroup.gnutella.gui.FileChooserHandler.getInput")) {
                return true;
            }
        }
        if (bug instanceof InternalError && msg.contains("getGraphics not implemented for this component")) {
            return true;
        }
        if (!msg.contains("com.limegroup.gnutella") && !msg.contains("org.limewire")) {
            return true;
        }
        if (this.intercepts(msg, "com.limegroup.gnutella.tables.MouseEventConsumptionChecker")) {
            return true;
        }
        return this.intercepts(msg, "com.limegroup.gnutella.gui.tables.LimeJTable.processMouseEvent");
    }

    private boolean intercepts(String msg, String inter) {
        int i2 = msg.indexOf(inter);
        if (i2 == -1) {
            return false;
        }
        if (msg.lastIndexOf("com.limegroup.gnutella", i2) != -1 && msg.lastIndexOf("org.limewire", i2) != -1) {
            return false;
        }
        if ((i2 += inter.length()) >= msg.length()) {
            return false;
        }
        return msg.indexOf("com.limegroup.gnutella", i2) == -1 || msg.lastIndexOf("org.limewire", i2) == -1;
    }
}

