/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.CheckBoxList;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class CheckBoxListPanel<E>
extends BoxPanel {
    private final CheckBoxList<E> list;

    public CheckBoxListPanel(Collection<E> elements, CheckBoxList.TextProvider<E> provider, boolean selected) {
        this.list = new CheckBoxList<E>(elements, provider, selected, 1);
        this.initialize();
    }

    private void initialize() {
        InternalJScrollPane scrollPane = new InternalJScrollPane(this.list);
        scrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
        this.add(scrollPane);
        this.add(Box.createVerticalStrut(6));
        this.add(new ButtonRow(this.list.getActions(), 0, 12));
    }

    public List<E> getSelectedElements() {
        return this.list.getCheckedElements();
    }

    public CheckBoxList<E> getList() {
        return this.list;
    }

    private class InternalJScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 5346177338334373472L;

        InternalJScrollPane(Component comp) {
            super(comp);
            this.getViewport().setBackground(UIManager.getColor("List.background"));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.getViewport().setBackground(UIManager.getColor("List.background"));
        }
    }
}

