/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SeperatorBorder;
import com.limegroup.gnutella.gui.tables.DefaultTableBevelledCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class CheckBoxList<E>
extends BoxPanel {
    static final int SELECT_FIRST_OFF = 1;
    private static final String TEXT_PROVIDER_PROPERTY = "textProvider";
    private static final int DEFAULT_ROW_HEIGHT = 22;
    private final Set<E> elements = new HashSet();
    private final Set<E> unchecked = new HashSet();
    private final Set<E> checked = new HashSet();
    private final Set<E> disabled = new HashSet();
    private final Set<E> bolded = new HashSet();
    private final String disabledTooltip;
    private final boolean removeable = false;
    private boolean selectOff;
    private JScrollPane scrollPane;
    private JTable checkBoxList;
    private CheckBoxListSelectionListener selectionListener;
    private CheckBoxListCheckChangeListener<?> checkListener;
    private Object parent;
    private int highLightedRow = -1;
    private Object selected;
    private TextProvider<E> provider;
    private final ExtrasProvider<E> extrasProvider;
    private List<E> items;
    private int visibleRowCount = -1;
    private CheckBoxCellEditor editor;

    private CheckBoxList(Collection<E> elements, Collection<E> notCheckedElements, TextProvider<E> provider, ExtrasProvider<E> separatorProvider, int mode) {
        this.disabledTooltip = null;
        this.provider = provider;
        this.extrasProvider = separatorProvider;
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        this.parent = this;
        this.selectionListener = null;
        this.selectOff = mode == 1;
        this.initialize();
        this.setElements(elements, notCheckedElements);
    }

    CheckBoxList(Collection<E> elements, TextProvider<E> provider, boolean checkAll, int mode) {
        this(elements, checkAll ? new HashSet() : elements, provider, null, mode);
    }

    private CheckBoxList(Collection<E> elements, TextProvider<E> provider, int mode) {
        this(elements, new HashSet(), provider, null, mode);
    }

    private static void ensureRowVisible(JTable table, int row) {
        if (row != -1) {
            Rectangle cellRect = table.getCellRect(row, 0, false);
            Rectangle visibleRect = table.getVisibleRect();
            if (!visibleRect.intersects(cellRect)) {
                table.scrollRectToVisible(cellRect);
            }
        }
    }

    private void setElements(Collection<E> elements, boolean checked) {
        if (checked) {
            this.setElements(elements, new HashSet());
        } else {
            this.setElements(elements, elements);
        }
    }

    private void setElements(Collection<E> elements, Collection<E> notCheckedElements) {
        this.items = new ArrayList<E>(elements);
        Object[][] rowData = new Object[elements.size()][1];
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            rowData[i2][0] = this.items.get(i2);
        }
        this.elements.clear();
        this.checked.clear();
        this.unchecked.clear();
        this.elements.addAll(elements);
        this.checked.addAll(elements);
        this.checked.removeAll(notCheckedElements);
        this.unchecked.addAll(notCheckedElements);
        if (rowData.length > 0) {
            this.selected = rowData[0];
        }
        this.checkBoxList.setModel(new DefaultTableModel(rowData, new String[]{""}));
    }

    void update() {
        ((DefaultTableModel)this.checkBoxList.getModel()).fireTableStructureChanged();
    }

    private void removeItem(Object key) {
        HashSet<E> newElements = new HashSet<E>(this.elements);
        HashSet<E> newUnchecked = new HashSet<E>(this.unchecked);
        newElements.remove(key);
        newUnchecked.remove(key);
        this.setElements(newElements, newUnchecked);
    }

    private void ensureRowVisible(E key) {
        int row;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        for (row = 0; row < this.checkBoxList.getModel().getRowCount(); ++row) {
            Object item = this.checkBoxList.getModel().getValueAt(row, 0);
            if (item == null) {
                return;
            }
            if (item.equals(key)) break;
        }
        CheckBoxList.ensureRowVisible(this.checkBoxList, row);
    }

    public void setItemSelected(E key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.selected = key;
        this.ensureRowVisible(key);
        this.editor.notifyChange();
        this.update();
    }

    public boolean setItemChecked(E key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.checked.contains(key)) {
            this.checked.add(key);
            this.unchecked.remove(key);
        }
        this.bolded.add(key);
        this.update();
        this.ensureRowVisible(key);
        new Timer(2000, new BoldRemoveListener(key)).start();
        return true;
    }

    public void setItemsEnabled(Set<E> keys2, boolean state) {
        if (state) {
            HashSet<E> toUncheck = new HashSet<E>(this.checked);
            toUncheck.retainAll(keys2);
            toUncheck.retainAll(this.disabled);
            this.checked.removeAll(toUncheck);
            this.unchecked.addAll(toUncheck);
            this.disabled.removeAll(keys2);
        } else {
            this.disabled.addAll(keys2);
        }
        this.update();
    }

    public void setItemsChecked(Set<E> keys2, boolean state) {
        if (state) {
            this.unchecked.removeAll(keys2);
            this.checked.addAll(keys2);
        } else {
            this.unchecked.addAll(keys2);
            this.checked.removeAll(keys2);
        }
        this.update();
    }

    @Override
    public boolean isEnabled() {
        if (this.checkBoxList != null) {
            return this.checkBoxList.isEnabled();
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBoxList.setEnabled(enabled);
    }

    public void setVisibleRowCount(int rows) {
        this.visibleRowCount = rows;
        this.setPreferredSize(this.getPreferredScrollableViewportSize());
    }

    private Dimension getPreferredScrollableViewportSize() {
        return this.visibleRowCount > 0 && this.items.size() > 0 ? new Dimension(this.getPreferredSize().width, this.visibleRowCount * this.checkBoxList.getRowHeight()) : this.getPreferredSize();
    }

    public void setTextProvider(TextProvider<E> provider) {
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        TextProvider<E> oldProvider = this.provider;
        this.provider = provider;
        this.firePropertyChange(TEXT_PROVIDER_PROPERTY, oldProvider, this.provider);
    }

    List<E> getCheckedElements() {
        if (this.checkBoxList.isEnabled() && this.checked.size() > 0) {
            HashSet<E> totalChecked = new HashSet<E>(this.checked);
            totalChecked.removeAll(this.disabled);
            return new LinkedList<E>(totalChecked);
        }
        return Collections.emptyList();
    }

    public List<E> getUncheckedElements() {
        if (!this.checkBoxList.isEnabled()) {
            return new LinkedList<E>(this.elements);
        }
        HashSet<E> toUncheck = new HashSet<E>(this.checked);
        toUncheck.retainAll(this.disabled);
        if (this.unchecked.size() > 0) {
            HashSet<E> totalUnchecked = new HashSet<E>(this.unchecked);
            totalUnchecked.addAll(toUncheck);
            return new LinkedList<E>(totalUnchecked);
        }
        return new LinkedList<E>(toUncheck);
    }

    public Set<E> getElements() {
        return new HashSet<E>(this.elements);
    }

    public void setElements(Collection<E> elements) {
        this.setElements(elements, true);
    }

    public Action[] getActions() {
        return new Action[]{new SelectAllAction(), new DeselectAllAction()};
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.editor = new CheckBoxCellEditor();
        this.checkBoxList = new CustomJTable();
        this.checkBoxList.setDefaultRenderer(Object.class, new CheckBoxCellRenderer());
        this.checkBoxList.setDefaultEditor(Object.class, this.editor);
        this.checkBoxList.setRowHeight(22);
        this.checkBoxList.setTableHeader(new JTableHeader());
        this.checkBoxList.getTableHeader().setVisible(false);
        this.checkBoxList.getTableHeader().setSize(0, 0);
        this.scrollPane = new JScrollPane(this.checkBoxList);
        this.add(this.scrollPane);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.checkBoxList == null) {
            return;
        }
        this.setBackground(UIManager.getColor("List.textBackground"));
        this.checkBoxList.setBackground(UIManager.getColor("List.background"));
        this.checkBoxList.setGridColor(UIManager.getColor("List.background"));
        this.scrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
    }

    public static interface TextProvider<E> {
        public String getText(E var1);

        public String getToolTipText(E var1);

        public Icon getIcon(E var1);
    }

    static interface ExtrasProvider<E> {
        public boolean isSeparated(E var1);

        public String getComment(E var1);
    }

    public static interface CheckBoxListSelectionListener {
        public void valueChanged(CheckBoxListSelectionEvent var1);
    }

    private class CheckBoxCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8487646158995389360L;
        private final com.limegroup.gnutella.gui.CheckBoxList$CheckBoxCellEditor.CustomEditorDelegate customDelegate;

        CheckBoxCellEditor() {
            super(new JCheckBox());
            IconDataCheckBox checkBox = new IconDataCheckBox();
            this.editorComponent = checkBox;
            checkBox.setRequestFocusEnabled(false);
            this.customDelegate = new CustomEditorDelegate();
            this.delegate = this.customDelegate;
            checkBox.addActionListener((ActionListener)this.customDelegate);
            checkBox.addTopMouseListener((MouseListener)this.customDelegate);
        }

        void notifyChange() {
            this.customDelegate.notifyChange();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }

        private class CustomEditorDelegate
        extends DefaultCellEditor.EditorDelegate
        implements MouseListener {
            private static final long serialVersionUID = -7007164079207676831L;
            private Object lastValue;

            CustomEditorDelegate() {
                super(CheckBoxCellEditor.this);
                this.lastValue = this.value;
            }

            void notifyChange() {
                this.lastValue = null;
            }

            @Override
            public void setValue(Object value) {
                boolean isSelected;
                if (value == null) {
                    return;
                }
                IconDataCheckBox box = (IconDataCheckBox)CheckBoxCellEditor.this.editorComponent;
                box.setData(value);
                box.setRemovable(false);
                box.setEnabled(CheckBoxList.this.isEnabled());
                if (CheckBoxList.this.disabled.contains(value)) {
                    if (CheckBoxList.this.disabledTooltip != null) {
                        box.setToolTipText(CheckBoxList.this.disabledTooltip);
                    }
                    box.setEnabled(false);
                    box.setSelected(false);
                    this.value = value;
                    return;
                }
                CheckBoxList.this.selected = value;
                if (this.lastValue == value) {
                    isSelected = true;
                } else {
                    isSelected = false;
                    CheckBoxList.this.repaint();
                    if (CheckBoxList.this.selectionListener != null) {
                        CheckBoxList.this.selectionListener.valueChanged(new CheckBoxListSelectionEvent(CheckBoxList.this.parent, value));
                    }
                }
                if (CheckBoxList.this.selectOff || isSelected) {
                    boolean decheck = CheckBoxList.this.unchecked.contains(value);
                    if (decheck) {
                        CheckBoxList.this.unchecked.remove(value);
                        CheckBoxList.this.checked.add(value);
                    } else {
                        CheckBoxList.this.unchecked.add(value);
                        CheckBoxList.this.checked.remove(value);
                    }
                    if (CheckBoxList.this.checkListener != null) {
                        CheckBoxList.this.checkListener.valueChanged(new CheckBoxListCheckChangeEvent<Object>(CheckBoxList.this.parent, value, decheck));
                    }
                }
                box.setSelected(CheckBoxList.this.checked.contains(value));
                this.lastValue = value;
                this.value = value;
            }

            @Override
            public Object getCellEditorValue() {
                return this.value;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.stopCellEditing();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        }
    }

    private class BoldRemoveListener
    implements ActionListener {
        private final E key;

        BoldRemoveListener(E key) {
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.bolded.remove(this.key);
            CheckBoxList.this.update();
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8173830762677196193L;

        SelectAllAction() {
            this.putValue("Name", I18n.tr("Select All"));
            this.putValue("ShortDescription", I18n.tr("Marks all Items as Selected"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.checked.addAll(CheckBoxList.this.unchecked);
            CheckBoxList.this.unchecked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    private class DeselectAllAction
    extends AbstractAction {
        DeselectAllAction() {
            this.putValue("Name", I18n.tr("Deselect All"));
            this.putValue("ShortDescription", I18n.tr("Deselects all Items in the List"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.unchecked.addAll(CheckBoxList.this.checked);
            CheckBoxList.this.checked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    private class CustomJTable
    extends JTable {
        private static final long serialVersionUID = 2839028569443961323L;

        private CustomJTable() {
        }

        private void shift(int row) {
            if (row != CheckBoxList.this.highLightedRow) {
                CheckBoxList.this.highLightedRow = row;
                CheckBoxList.this.repaint();
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }
    }

    private class CheckBoxCellRenderer
    extends DefaultTableBevelledCellRenderer {
        private final IconDataCheckBox checkBox;

        private CheckBoxCellRenderer() {
            this.checkBox = new IconDataCheckBox();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.checkBox.setData(value);
            }
            this.checkBox.setRemovable(false);
            this.checkBox.setHighlight(row == CheckBoxList.this.highLightedRow);
            if (!CheckBoxList.this.selectOff && value != null && value.equals(CheckBoxList.this.selected)) {
                this.checkBox.setBackground(UIManager.getColor("List.selectionBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.checkBox.setBackground(UIManager.getColor("List.textBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.textForeground"));
            }
            if (CheckBoxList.this.bolded.contains(value)) {
                this.checkBox.setBold(true);
            } else {
                this.checkBox.setBold(false);
            }
            if (CheckBoxList.this.disabled.contains(value)) {
                if (CheckBoxList.this.disabledTooltip != null) {
                    this.checkBox.setToolTipText(CheckBoxList.this.disabledTooltip);
                }
                this.checkBox.setEnabled(false);
                this.checkBox.setSelected(false);
            } else {
                this.checkBox.setSelected(!CheckBoxList.this.unchecked.contains(value));
                this.checkBox.setEnabled(table.isEnabled());
            }
            return this.checkBox;
        }
    }

    private class IconDataCheckBox
    extends BoxPanel {
        private static final long serialVersionUID = 7370736947464891601L;
        private E obj;
        private final JCheckBox checkBox;
        private final JLabel label;
        private final com.limegroup.gnutella.gui.CheckBoxList$IconDataCheckBox.DeleteButton button;
        private final Border blankBorder;
        private final SeperatorBorder sepBorder;
        private final Font originalFont;
        private final Font boldFont;

        IconDataCheckBox() {
            super(0);
            this.sepBorder = new SeperatorBorder();
            this.blankBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, (Icon)null);
            this.label = new JLabel();
            this.label.setBorder(this.blankBorder);
            this.checkBox = new JCheckBox("", true);
            this.button = new DeleteButton();
            this.add(Box.createHorizontalStrut(4));
            this.add(this.checkBox);
            this.add(this.label);
            this.add(Box.createHorizontalStrut(1));
            this.add(Box.createHorizontalGlue());
            this.add((Component)this.button);
            this.updateLook();
            this.originalFont = this.label.getFont();
            this.boldFont = this.originalFont.deriveFont(this.originalFont.getStyle() | 1 | 2);
        }

        void setRemovable(boolean state) {
            this.button.setVisible(state);
        }

        void setData(E obj) {
            this.obj = obj;
            String text = CheckBoxList.this.provider.getText(obj);
            this.label.setIcon(CheckBoxList.this.provider.getIcon(obj));
            if (CheckBoxList.this.extrasProvider != null) {
                this.label.setText(text + " " + CheckBoxList.this.extrasProvider.getComment(obj));
                if (CheckBoxList.this.extrasProvider.isSeparated(obj)) {
                    this.label.setBorder(this.sepBorder);
                } else {
                    this.label.setBorder(this.blankBorder);
                }
            } else {
                this.label.setText(text);
            }
            this.setToolTipText(CheckBoxList.this.provider.getToolTipText(obj));
        }

        void setHighlight(boolean b) {
            this.button.setHighlight(b);
            if (b) {
                this.setToolTipText("Remove...");
            } else {
                this.setToolTipText(CheckBoxList.this.provider.getToolTipText(this.obj));
            }
        }

        void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.checkBox.setEnabled(enabled);
            this.label.setEnabled(enabled);
        }

        @Override
        public void setForeground(Color c) {
            if (this.label != null) {
                this.label.setForeground(c);
            }
        }

        void setBold(boolean b) {
            if (b) {
                this.label.setFont(this.boldFont);
            } else {
                this.label.setFont(this.originalFont);
            }
        }

        private void updateLook() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setForeground(UIManager.getColor("List.foreground"));
            this.checkBox.setFont(UIManager.getFont("Table.font"));
            this.checkBox.setOpaque(false);
            this.label.setBackground(UIManager.getColor("List.background"));
            this.label.setForeground(UIManager.getColor("List.foreground"));
            this.label.setFont(UIManager.getFont("Table.font"));
            this.label.setOpaque(false);
        }

        void addActionListener(ActionListener l) {
            this.checkBox.addActionListener(l);
        }

        void addTopMouseListener(MouseListener l) {
            this.addMouseListener(l);
            this.label.addMouseListener(l);
        }

        private class DeleteButton
        extends JButton {
            private static final long serialVersionUID = 2099563643830495610L;
            private final Icon iconReg = GUIMediator.getThemeImage("delete_small");
            private final Icon iconHi = GUIMediator.getThemeImage("delete_small_hi");

            DeleteButton() {
                this.setIcon(this.iconReg);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setContentAreaFilled(false);
                this.setVisible(false);
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        CheckBoxList.this.removeItem(IconDataCheckBox.this.obj);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }

            void setHighlight(boolean b) {
                if (b) {
                    this.setIcon(this.iconHi);
                } else {
                    this.setIcon(this.iconReg);
                }
            }
        }
    }

    public static class CheckBoxListCheckChangeEvent<E>
    extends EventObject {
        private static final long serialVersionUID = -2715339837857605924L;
        private final E selected;
        private final boolean checked;

        CheckBoxListCheckChangeEvent(Object source2, E selected, boolean checked) {
            super(source2);
            this.selected = selected;
            this.checked = checked;
        }

        public E getSelected() {
            return this.selected;
        }

        public boolean getChecked() {
            return this.checked;
        }
    }

    public static class CheckBoxListSelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 6985964072155472329L;
        private final Object selected;

        CheckBoxListSelectionEvent(Object source2, Object selected) {
            super(source2);
            this.selected = selected;
        }

        public Object getSelected() {
            return this.selected;
        }
    }

    public static interface CheckBoxListCheckChangeListener<E> {
        public void valueChanged(CheckBoxListCheckChangeEvent<E> var1);
    }
}

