/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.concurrent.concurrent.ThreadExecutor;
import com.frostwire.service.ErrorService;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.SystemUtils;

public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Logger LOG = Logger.getLogger(LifecycleManagerImpl.class);
    private final AtomicBoolean preinitializeBegin = new AtomicBoolean(false);
    private final AtomicBoolean preinitializeDone = new AtomicBoolean(false);
    private final AtomicBoolean backgroundBegin = new AtomicBoolean(false);
    private final AtomicBoolean backgroundDone = new AtomicBoolean(false);
    private final AtomicBoolean startBegin = new AtomicBoolean(false);
    private final AtomicBoolean startDone = new AtomicBoolean(false);
    private final AtomicBoolean shutdownBegin = new AtomicBoolean(false);
    private final AtomicBoolean shutdownDone = new AtomicBoolean(false);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final LimeCoreGlue limeCoreGlue;
    private final List<Thread> SHUTDOWN_ITEMS = Collections.synchronizedList(new LinkedList());

    LifecycleManagerImpl(LimeCoreGlue limeCoreGlue) {
        this.limeCoreGlue = limeCoreGlue;
    }

    private static String parseCommand(String toCall) {
        if (toCall.startsWith("\"")) {
            int end = toCall.indexOf("\"", 1);
            if (end > -1) {
                return toCall.substring(0, end + 1);
            }
            return toCall + "\"";
        }
        int space = toCall.indexOf(" ");
        if (space > -1) {
            return toCall.substring(0, space);
        }
        return toCall;
    }

    @Override
    public boolean isLoaded() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STARTING;
    }

    @Override
    public boolean isStarted() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STOPPED;
    }

    @Override
    public void installListeners() {
        if (this.preinitializeBegin.getAndSet(true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        this.preinitializeDone.set(true);
    }

    @Override
    public void loadBackgroundTasks() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        ThreadExecutor.startThread(this::doBackgroundTasks, "BackgroundTasks");
    }

    private void loadBackgroundTasksBlocking() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        this.doBackgroundTasks();
    }

    @Override
    public void start() {
        if (this.startBegin.getAndSet(true)) {
            return;
        }
        try {
            this.doStart();
        }
        finally {
            this.startLatch.countDown();
        }
    }

    private void doStart() {
        this.loadBackgroundTasksBlocking();
        if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
            this.startManualGCThread();
        }
        this.startDone.set(true);
    }

    @Override
    public void shutdown() {
        try {
            this.doShutdown();
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    private void doShutdown() {
        if (!this.startBegin.get() || this.shutdownBegin.getAndSet(true)) {
            return;
        }
        try {
            this.startLatch.await();
        }
        catch (InterruptedException ie) {
            LOG.error("Interrupted while waiting to finish starting", ie);
            return;
        }
        SettingsGroupManager.instance().save();
        LOG.info("Stopping BTEngine...");
        BTEngine.getInstance().stop();
        LOG.info("BTEngine stopped");
        this.shutdownDone.set(true);
    }

    @Override
    public void shutdown(String toExecute) {
        this.shutdown();
        if (toExecute != null) {
            try {
                String cmd = LifecycleManagerImpl.parseCommand(toExecute).trim();
                String params = toExecute.substring(cmd.length()).trim();
                if (OSUtils.isWindowsVista()) {
                    SystemUtils.openFile(cmd, params);
                } else {
                    new ProcessBuilder(cmd, params).start();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addShutdownItem(Thread t) {
        if (this.shutdownBegin.get()) {
            return;
        }
        this.SHUTDOWN_ITEMS.add(t);
    }

    private void doBackgroundTasks() {
        this.limeCoreGlue.install();
        this.backgroundDone.set(true);
    }

    private State getCurrentState() {
        if (this.shutdownBegin.get()) {
            return State.STOPPED;
        }
        if (this.startDone.get()) {
            return State.STARTED;
        }
        if (this.startBegin.get()) {
            return State.STARTING;
        }
        return State.NONE;
    }

    private void startManualGCThread() {
        Thread t = ThreadExecutor.newManagedThread(() -> {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
            }
        }, "ManualGC");
        t.setDaemon(true);
        t.start();
    }

    private static enum State {
        NONE,
        STARTING,
        STARTED,
        STOPPED;

    }
}

