/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Inst;
import java.util.Arrays;

final class Prog {
    Inst[] inst = new Inst[10];
    int instSize = 0;
    int start;
    int numCap = 2;

    Prog() {
    }

    Inst getInst(int pc) {
        return this.inst[pc];
    }

    int numInst() {
        return this.instSize;
    }

    void addInst(int op) {
        if (this.instSize >= this.inst.length) {
            this.inst = Arrays.copyOf(this.inst, this.inst.length * 2);
        }
        this.inst[this.instSize] = new Inst(op);
        ++this.instSize;
    }

    Inst skipNop(int pc) {
        Inst i2 = this.inst[pc];
        while (i2.op == 7 || i2.op == 3) {
            i2 = this.inst[pc];
            pc = i2.out;
        }
        return i2;
    }

    boolean prefix(StringBuilder prefix) {
        Inst i2 = this.skipNop(this.start);
        if (!Inst.isRuneOp(i2.op) || i2.runes.length != 1) {
            return i2.op == 6;
        }
        while (Inst.isRuneOp(i2.op) && i2.runes.length == 1 && (i2.arg & 1) == 0) {
            prefix.appendCodePoint(i2.runes[0]);
            i2 = this.skipNop(i2.out);
        }
        return i2.op == 6;
    }

    int startCond() {
        int flag = 0;
        int pc = this.start;
        block5: while (true) {
            Inst i2 = this.inst[pc];
            switch (i2.op) {
                case 4: {
                    flag |= i2.arg;
                    break;
                }
                case 5: {
                    return -1;
                }
                case 3: 
                case 7: {
                    break;
                }
                default: {
                    break block5;
                }
            }
            pc = i2.out;
        }
        return flag;
    }

    int next(int l) {
        Inst i2 = this.inst[l >> 1];
        if ((l & 1) == 0) {
            return i2.out;
        }
        return i2.arg;
    }

    void patch(int l, int val) {
        while (l != 0) {
            Inst i2 = this.inst[l >> 1];
            if ((l & 1) == 0) {
                l = i2.out;
                i2.out = val;
                continue;
            }
            l = i2.arg;
            i2.arg = val;
        }
    }

    int append(int l1, int l2) {
        int next;
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int last = l1;
        while ((next = this.next(last)) != 0) {
            last = next;
        }
        Inst i2 = this.inst[last >> 1];
        if ((last & 1) == 0) {
            i2.out = l2;
        } else {
            i2.arg = l2;
        }
        return l1;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int pc = 0; pc < this.instSize; ++pc) {
            int len = out.length();
            out.append(pc);
            if (pc == this.start) {
                out.append('*');
            }
            out.append("        ".substring(out.length() - len)).append(this.inst[pc]).append('\n');
        }
        return out.toString();
    }
}

