/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.filetypes;

import com.frostwire.util.filetypes.Action;
import com.frostwire.util.filetypes.AppAssociationReader;
import com.frostwire.util.filetypes.AppAssociationReaderFactory;
import com.frostwire.util.filetypes.AppAssociationWriter;
import com.frostwire.util.filetypes.AppAssociationWriterFactory;
import com.frostwire.util.filetypes.AppUtility;
import com.frostwire.util.filetypes.Association;
import com.frostwire.util.filetypes.AssociationAlreadyRegisteredException;
import com.frostwire.util.filetypes.AssociationNotRegisteredException;
import com.frostwire.util.filetypes.RegisterFailedException;
import java.util.Iterator;
import java.util.List;

public class AssociationService {
    private final AppAssociationReader appAssocReader = AppAssociationReaderFactory.newInstance();
    private final AppAssociationWriter appAssocWriter = AppAssociationWriterFactory.newInstance();

    public Association getMimeTypeAssociation(String mimeType) {
        Iterator<Object> iter;
        if (mimeType == null) {
            throw new IllegalArgumentException("The specified mime type is null");
        }
        if (!this.appAssocReader.isMimeTypeExist(mimeType)) {
            return null;
        }
        Association assoc = new Association();
        List<String> fileExtList = this.appAssocReader.getFileExtListByMimeType(mimeType);
        String iconFileName = this.appAssocReader.getIconFileNameByMimeType(mimeType);
        String description = this.appAssocReader.getDescriptionByMimeType(mimeType);
        List<Action> actionList = this.appAssocReader.getActionListByMimeType(mimeType);
        assoc.setMimeType(mimeType);
        if (fileExtList != null && (iter = fileExtList.iterator()) != null) {
            while (iter.hasNext()) {
                assoc.addFileExtension((String)iter.next());
            }
        }
        if (iconFileName != null) {
            assoc.setIconFileName(iconFileName);
        }
        if (description != null) {
            assoc.setDescription(description);
        }
        if (actionList != null && (iter = actionList.iterator()) != null) {
            while (iter.hasNext()) {
                assoc.addAction((Action)iter.next());
            }
        }
        return assoc;
    }

    public Association getFileExtensionAssociation(String fileExt) {
        Iterator<Action> iter;
        if (fileExt == null) {
            throw new IllegalArgumentException("The specified file extension is null");
        }
        if (!this.appAssocReader.isFileExtExist(fileExt = AppUtility.addDotToFileExtension(fileExt))) {
            return null;
        }
        Association assoc = new Association();
        String mimeType = this.appAssocReader.getMimeTypeByFileExt(fileExt);
        String iconFileName = this.appAssocReader.getIconFileNameByFileExt(fileExt);
        String description = this.appAssocReader.getDescriptionByFileExt(fileExt);
        List<Action> actionList = this.appAssocReader.getActionListByFileExt(fileExt);
        assoc.addFileExtension(fileExt);
        if (iconFileName != null) {
            assoc.setIconFileName(iconFileName);
        }
        if (mimeType != null) {
            assoc.setMimeType(mimeType);
        }
        if (description != null) {
            assoc.setDescription(description);
        }
        if (actionList != null && (iter = actionList.iterator()) != null) {
            while (iter.hasNext()) {
                assoc.addAction(iter.next());
            }
        }
        return assoc;
    }

    public void registerUserAssociation(Association assoc) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        if (assoc == null) {
            throw new IllegalArgumentException("The specified association is null");
        }
        this.appAssocWriter.checkAssociationValidForRegistration(assoc);
        if (this.appAssocWriter.isAssociationExist(assoc, 1)) {
            throw new AssociationAlreadyRegisteredException("Association already exists!");
        }
        this.appAssocWriter.registerAssociation(assoc, 1);
    }

    public void unregisterUserAssociation(Association assoc) throws AssociationNotRegisteredException, RegisterFailedException {
        if (assoc == null) {
            throw new IllegalArgumentException("The specified association is null");
        }
        this.appAssocWriter.checkAssociationValidForUnregistration(assoc);
        if (!this.appAssocWriter.isAssociationExist(assoc, 1)) {
            throw new AssociationNotRegisteredException("Assocation not exists!");
        }
        this.appAssocWriter.unregisterAssociation(assoc, 1);
    }
}

