/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPool
extends ThreadPoolExecutor {
    private static boolean DEBUG_MODE_ON = false;
    private static final long THREAD_STACK_SIZE = 4096L;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;
    private static Logger LOG = Logger.getLogger(ThreadPool.class);

    public ThreadPool(String name, int maximumPoolSize, BlockingQueue<Runnable> workQueue, boolean daemon) {
        super(maximumPoolSize, maximumPoolSize, 1L, TimeUnit.SECONDS, workQueue, new PoolThreadFactory(daemon));
        this.name = name;
    }

    public ThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTimeInSeconds, BlockingQueue<Runnable> workQueue, boolean daemon) {
        super(corePoolSize, maximumPoolSize, keepAliveTimeInSeconds, TimeUnit.SECONDS, workQueue, new PoolThreadFactory(daemon));
        this.name = name;
    }

    public static ExecutorService newThreadPool(String name, int maxThreads, boolean daemon) {
        ThreadPool pool = new ThreadPool(name, maxThreads, new LinkedBlockingQueue<Runnable>(), daemon);
        return Executors.unconfigurableExecutorService(pool);
    }

    public static ExecutorService newThreadPool(String name, int maxThreads) {
        return ThreadPool.newThreadPool(name, maxThreads, false);
    }

    public static ExecutorService newThreadPool(String name, boolean daemon) {
        ThreadPool pool = new ThreadPool(name, Integer.MAX_VALUE, new LinkedBlockingQueue<Runnable>(), daemon);
        return Executors.unconfigurableExecutorService(pool);
    }

    public static ExecutorService newThreadPool(String name) {
        return ThreadPool.newThreadPool(name, false);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        String threadName = null;
        if (r instanceof Thread) {
            Thread thread2 = (Thread)r;
            threadName = thread2.getName();
        }
        t.setName(this.name + "-thread-" + this.threadNumber.getAndIncrement() + "-" + (String)(threadName != null ? threadName : "@" + r.hashCode()));
        if (DEBUG_MODE_ON && this.name.startsWith("SearchManager")) {
            LOG.info("ThreadPool(" + this.name + "): beforeExecute: " + t.getName());
            LOG.info("ThreadPool(" + this.name + "): pool size: " + this.getPoolSize());
            LOG.info("ThreadPool(" + this.name + "): active count: " + this.getActiveCount());
            LOG.info("ThreadPool(" + this.name + "): queue size: " + this.getQueue().size());
            LOG.info("ThreadPool(" + this.name + "): task count: " + this.getTaskCount());
            LOG.info("ThreadPool(" + this.name + "): completed task count: " + this.getCompletedTaskCount());
            LOG.info("ThreadPool(" + this.name + "): end of beforeExecute: " + t.getName());
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable throwable) {
        Thread t = Thread.currentThread();
        Thread.currentThread().setName(this.name + "-thread-idle");
    }

    private static final class PoolThreadFactory
    implements ThreadFactory {
        private final boolean daemon;
        private final ThreadGroup threadGroup = new ThreadGroup("PoolThreadFactoryGroup");

        PoolThreadFactory(boolean daemon) {
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadGroup, r, "", 4096L);
            t.setDaemon(this.daemon);
            return t;
        }
    }
}

