/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static boolean contains(String input, String pattern) {
        return StringUtils.contains(input, pattern, false);
    }

    public static boolean contains(String input, String pattern, boolean ignoreCase) {
        int n = pattern.length();
        int last = 0;
        int i2 = 0;
        while (i2 < n) {
            int k;
            int j;
            int c = 32;
            for (j = i2; j < n; ++j) {
                char c2 = pattern.charAt(j);
                if (c2 != ' ' && c2 != '+' && c2 != '*') continue;
                c = c2;
                break;
            }
            if ((k = StringUtils.subset(pattern, i2, j, input, last, ignoreCase)) < 0) {
                return false;
            }
            if (c == 32 || c == 43) {
                last = 0;
            } else if (c == 42) {
                last = k + j - i2;
            }
            i2 = j + 1;
        }
        return true;
    }

    private static int subset(String little, int littleStart, int littleStop, String big, int bigStart, boolean ignoreCase) {
        if (ignoreCase) {
            int n = big.length() - (littleStop - littleStart) + 1;
            block0: for (int i2 = bigStart; i2 < n; ++i2) {
                int n2 = littleStop - littleStart;
                for (int j = 0; j < n2; ++j) {
                    char c2;
                    char c1 = big.charAt(i2 + j);
                    if (c1 != (c2 = little.charAt(littleStart + j)) && c1 != StringUtils.toOtherCase(c2)) continue block0;
                }
                return i2;
            }
            return -1;
        }
        int n = big.length() - (littleStop - littleStart) + 1;
        block2: for (int i3 = bigStart; i3 < n; ++i3) {
            int n2 = littleStop - littleStart;
            for (int j = 0; j < n2; ++j) {
                char c2;
                char c1 = big.charAt(i3 + j);
                if (c1 != (c2 = little.charAt(littleStart + j))) continue block2;
            }
            return i3;
        }
        return -1;
    }

    public static char toOtherCase(char c) {
        char i2 = c;
        int A = 65;
        int Z = 90;
        int a = 97;
        int z = 122;
        int SHIFT = 32;
        if (i2 < 'A') {
            return c;
        }
        if (i2 <= 'Z') {
            return (char)(i2 + 32);
        }
        if (i2 < 'a') {
            return c;
        }
        if (i2 <= 'z') {
            return (char)(i2 - 32);
        }
        return c;
    }

    public static String[] split(String s, char delimiter) {
        return StringUtils.split(s, Character.toString(delimiter));
    }

    public static String[] split(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[0]);
    }

    public static String[] splitNoCoalesce(String s, char delimiter) {
        return StringUtils.splitNoCoalesce(s, Character.toString(delimiter));
    }

    public static String[] splitNoCoalesce(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        ArrayList<String> tokens = new ArrayList<String>();
        boolean gotDelimiter = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && delimiters.contains(token)) {
                if (gotDelimiter) {
                    tokens.add("");
                }
                gotDelimiter = true;
                continue;
            }
            tokens.add(token);
            gotDelimiter = false;
        }
        if (gotDelimiter && !tokens.isEmpty()) {
            tokens.add("");
        }
        return tokens.toArray(new String[0]);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        int pl = prefix.length();
        if (s.length() < pl) {
            return false;
        }
        for (int i2 = 0; i2 < pl; ++i2) {
            char pc;
            char sc = s.charAt(i2);
            if (sc == (pc = prefix.charAt(i2)) || (sc = Character.toUpperCase(sc)) == (pc = Character.toUpperCase(pc)) || (sc = Character.toLowerCase(sc)) == (pc = Character.toLowerCase(pc))) continue;
            return false;
        }
        return true;
    }

    public static String replace(String str, String old_str, String new_str) {
        int o = 0;
        StringBuilder buf = new StringBuilder();
        int i2 = str.indexOf(old_str);
        while (i2 > -1) {
            if (i2 > o) {
                buf.append(str.substring(o, i2));
            }
            buf.append(new_str);
            o = i2 + old_str.length();
            i2 = str.indexOf(old_str, i2 + 1);
        }
        buf.append(str.substring(o, str.length()));
        return buf.toString();
    }

    public static String truncate(String string, int maxLen) {
        if (string.length() <= maxLen) {
            return string;
        }
        return string.substring(0, maxLen);
    }

    public static int indexOfIgnoreCase(String str, String substring) {
        return StringUtils.indexOfIgnoreCase(str, substring, Locale.getDefault());
    }

    public static int indexOfIgnoreCase(String str, String substring, Locale locale) {
        return str.toLowerCase(locale).indexOf(substring.toLowerCase(locale));
    }

    public static String getASCIIString(byte[] bytes) {
        return StringUtils.getEncodedString(bytes, "ISO-8859-1");
    }

    public static String getUTF8String(byte[] bytes) {
        return StringUtils.getEncodedString(bytes, "UTF-8");
    }

    private static String getEncodedString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public static String explode(String[] array, String delimeter) {
        StringBuilder sb = new StringBuilder();
        if (array.length > 0) {
            sb.append(array[0]);
            for (int i2 = 1; i2 < array.length; ++i2) {
                sb.append(delimeter);
                sb.append(array[i2]);
            }
        }
        return sb.toString();
    }

    public static String explode(Collection<String> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (!collection.isEmpty()) {
            Iterator<String> i2 = collection.iterator();
            sb.append(i2.next());
            while (i2.hasNext()) {
                sb.append(delimiter);
                sb.append(i2.next());
            }
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String s, boolean trim) {
        return s == null || (trim ? s.trim().length() == 0 : s.length() == 0);
    }

    public static boolean isNullOrEmpty(String s) {
        return StringUtils.isNullOrEmpty(s, false);
    }

    public static String removeDoubleSpaces(String s) {
        return s != null ? s.replaceAll("\\s+", " ") : null;
    }

    public static String removeUnicodeCharacters(String s) {
        return s.replaceAll("[^\\p{L}\\p{N}\\p{P}\\p{Z}]", "");
    }

    public static String getLocaleString(Map<String, String> strMap, String defaultStr) {
        String str;
        String localeLanguageCode = Locale.getDefault().getLanguage();
        if (StringUtils.isNullOrEmpty(localeLanguageCode, true)) {
            localeLanguageCode = "en";
        }
        if (StringUtils.isNullOrEmpty(str = strMap.get(localeLanguageCode), true)) {
            str = defaultStr;
        }
        return str;
    }

    public static int quickHash(String s) {
        int hash = 1;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            hash = hash * s.charAt(i2) % Integer.MAX_VALUE;
        }
        return hash;
    }

    public static String fromHtml(String html) {
        html = html.replaceAll("(?s)<!--.*?-->", "");
        html = html.replaceAll("<(\\w+)\\s+style=\"[^\"]*\">", "<$1>");
        html = html.replaceAll("(?i)<script.*?</script>", "");
        html = html.replaceAll("&nbsp;", " ");
        html = html.replaceAll("&amp;", "&");
        html = html.replaceAll("&lt;", "<");
        html = html.replaceAll("&gt;", ">");
        html = html.replaceAll("&quot;", "\"");
        html = html.replaceAll("&apos;", "'");
        html = html.replaceAll("(?i)<br\\s*/?>", System.lineSeparator());
        html = html.replaceAll("(?i)<(em|i)>(.*?)</\\1>", "_$2_");
        html = html.replaceAll("(?i)<(strong|b)>(.*?)</\\1>", "*$2*");
        Pattern pattern = Pattern.compile("<.*?>", 32);
        Matcher matcher = pattern.matcher(html);
        html = matcher.replaceAll("");
        html = html.replaceAll("\\s+", " ");
        html = html.trim();
        return html;
    }
}

