/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class Ssl {
    private static final Logger LOG = Logger.getLogger(Ssl.class);
    private static final HostnameVerifier FW_HOSTNAME_VERIFIER = new FWHostnameVerifier();
    private static final X509TrustManager NULL_TRUST_MANAGER = new NullTrustManager();
    private static final SSLSocketFactory NULL_SOCKET_FACTORY = Ssl.buildNullSSLSocketFactory();

    private Ssl() {
    }

    public static void addValidDomain(String domain) {
        FWHostnameVerifier.addValidDomain(domain);
    }

    public static HostnameVerifier fwHostnameVerifier() {
        return FW_HOSTNAME_VERIFIER;
    }

    public static X509TrustManager nullTrustManager() {
        return NULL_TRUST_MANAGER;
    }

    public static SSLSocketFactory nullSocketFactory() {
        return NULL_SOCKET_FACTORY;
    }

    private static SSLSocketFactory buildNullSSLSocketFactory() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{Ssl.nullTrustManager()}, new SecureRandom());
            SSLSocketFactory d = sc.getSocketFactory();
            return new WrapSSLSocketFactory(d);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static final class FWHostnameVerifier
    implements HostnameVerifier {
        private static final String[] validDomains = new String[]{"api-v2.soundcloud.com", "api.frostclick.com", "archive.org", "btdig.com", "cdninstagram.com", "clients1.google.com", "cloudflaressl.com", "dl.frostwire.com", "eztv.re", "fbcdn.net", "github.com", "github.io", "google.com", "githubusercontent.com", "gtdb.to", "idope.se", "igcdn.com", "igsonar.com", "instagram.com", "magnetdl.com", "nyaa.si", "pirate-bay.info", "pirate-bays.net", "piratebay.live", "pirateproxy.live", "scontent.cdninstagram.com", "sndcdn.com", "sni.cloudflaressl.com", "static.frostclick.com", "static.frostwire.com", "thehiddenbay.com", "thepiratebay-unblocked.org", "thepiratebay.org", "thepiratebay.party", "thepiratebay.zone", "thepiratebay0.org", "thepiratebay10.org", "thepiratebay7.com", "torrent-paradise.ml", "torrentz2.nz", "tpb.party", "update.frostwire.com", "www.1377x.to", "www.frostwire.com", "www.limetorrents.info", "www.limetorrents.lol", "www.limetorrents.pro", "www.magnetdl.com", "www.pirate-bay.net", "www.torlock.com", "www.torrentdownloads.me", "www.torrentdownloads.pro", "www.yify-torrent.org", "youtube.com", "yify-torrent.cc", "youtu.be", "yts-movie.cc", "zoink.ch", "zooqle.com"};
        private static final HashSet<String> validDomainsSet = new HashSet();

        FWHostnameVerifier() {
        }

        public static void addValidDomain(String domain) {
            LOG.info("addValidDomain: " + domain);
            validDomainsSet.add(domain);
            int firstDotIndex = domain.indexOf(".");
            int secondDotIndex = domain.indexOf(".", firstDotIndex);
            if (secondDotIndex != -1) {
                String baseDomain = domain.substring(firstDotIndex + 1);
                LOG.info("addValidDomain: " + baseDomain);
                validDomainsSet.add(baseDomain);
            }
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            if (!validDomainsSet.contains(s)) {
                for (String baseDomain : validDomainsSet) {
                    if (!s.contains(baseDomain)) continue;
                    validDomainsSet.add(s);
                    return true;
                }
            }
            return validDomainsSet.contains(s);
        }

        static {
            Collections.addAll(validDomainsSet, validDomains);
        }
    }

    private static final class WrapSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory d;

        WrapSSLSocketFactory(SSLSocketFactory d) {
            this.d = d;
        }

        @Override
        public Socket createSocket(String s, int i2) throws IOException {
            return this.d.createSocket(s, i2);
        }

        @Override
        public Socket createSocket(String s, int i2, InetAddress inetAddress, int i1) throws IOException {
            return this.d.createSocket(s, i2, inetAddress, i1);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i2) throws IOException {
            return this.d.createSocket(inetAddress, i2);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i2, InetAddress inetAddress1, int i1) throws IOException {
            return this.d.createSocket(inetAddress, i2, inetAddress1, i1);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.d.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.d.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i2, boolean b) throws IOException {
            return this.d.createSocket(socket, s, i2, b);
        }
    }

    private static final class NullTrustManager
    implements X509TrustManager {
        private NullTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

