/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.UnameReader;
import java.io.File;
import java.util.Locale;

public class OSUtils {
    private static boolean _isWindows;
    private static boolean _isWindowsNT;
    private static boolean _isWindowsXP;
    private static boolean _isWindows95;
    private static boolean _isWindows98;
    private static boolean _isWindowsMe;
    private static boolean _isWindowsVista;
    private static boolean _isWindows7;
    private static boolean _supportsTray;
    private static boolean _isMacOSX;
    private static boolean _isLinux;
    private static boolean _isUbuntu;
    private static boolean _isFedora;
    private static boolean _isSolaris;
    private static boolean _isOS2;
    private static File APP_X_MANIFEST_XML;

    private static void setOperatingSystems() {
        _isWindows = false;
        _isWindows7 = false;
        _isWindowsVista = false;
        _isWindowsXP = false;
        _isWindowsMe = false;
        _isWindowsNT = false;
        _isWindows98 = false;
        _isWindows95 = false;
        _isLinux = false;
        _isUbuntu = false;
        _isFedora = false;
        _isMacOSX = false;
        _isSolaris = false;
        _isOS2 = false;
        String os = System.getProperty("os.name");
        System.out.println("os.name=\"" + os + "\"");
        os = os.toLowerCase(Locale.US);
        _isWindows = os.contains("windows");
        _isSolaris = os.contains("solaris");
        _isLinux = os.contains("linux");
        _isOS2 = os.contains("os/2");
        if (_isWindows) {
            _isWindows7 = os.contains("windows 7");
            _isWindowsVista = os.contains("windows vista");
            _isWindowsXP = os.contains("windows xp");
            _isWindowsNT = os.contains("windows nt");
            _isWindowsMe = os.contains("windows me");
            _isWindows98 = os.contains("windows 98");
            _isWindows95 = os.contains("windows 95");
        }
        if (_isLinux) {
            String unameStr = UnameReader.read();
            _isUbuntu = unameStr.contains("buntu") || unameStr.contains("ebian");
            boolean bl = _isFedora = unameStr.contains("edora") || unameStr.contains("ed Hat");
        }
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (os.startsWith("mac os") && os.endsWith("x")) {
            _isMacOSX = true;
        }
    }

    public static String getOS() {
        return System.getProperty("os.name");
    }

    private static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getFullOS() {
        return OSUtils.getOS() + "-" + OSUtils.getOSVersion() + "-" + OSUtils.getArchitecture();
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsNT() {
        return _isWindowsNT;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindowsMe() {
        return _isWindowsMe;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isWindows7() {
        return _isWindows7;
    }

    public static boolean isNativeThemeWindows() {
        return OSUtils.isWindowsVista() || OSUtils.isWindowsXP();
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isAnyMac() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUbuntu() {
        return _isUbuntu;
    }

    public static boolean isFedora() {
        return _isFedora;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    private static boolean isHighLoadOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isGoodWindows() {
        return OSUtils.isWindows() && OSUtils.isHighLoadOS();
    }

    public static boolean isModernWindows() {
        return OSUtils.isWindows() && !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT && !_isWindowsXP;
    }

    public static boolean supportsTrash() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    public static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getMacOSArchitecture() {
        String os_arch = System.getProperty("os.arch");
        if ("aarch64".equals(os_arch)) {
            return "arm64";
        }
        if ("i386".equals(os_arch) || "x86".equals(os_arch)) {
            return "x86_64";
        }
        return os_arch;
    }

    public static boolean isMachineX64() {
        String value = System.getProperty("sun.arch.data.model");
        return value != null && value.equals("64");
    }

    public static boolean isMacOSCatalina105OrNewer() {
        String osVersion = OSUtils.getOSVersion();
        String[] os_parts = osVersion.split("\\.");
        int major = Integer.parseInt(os_parts[0]);
        int minor = Integer.parseInt(os_parts[1]);
        return OSUtils.isAnyMac() && major >= 10 && minor >= 15;
    }

    public static boolean isWindowsAppStoreInstall() {
        if (!OSUtils.isWindows()) {
            return false;
        }
        if (APP_X_MANIFEST_XML == null) {
            APP_X_MANIFEST_XML = new File("AppxManifest.xml");
        }
        return APP_X_MANIFEST_XML.exists() && APP_X_MANIFEST_XML.isFile();
    }

    static {
        OSUtils.setOperatingSystems();
        APP_X_MANIFEST_XML = null;
    }
}

