/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HistoHashMap<K> {
    private final HashMap<K, Integer> map = new HashMap();
    private final Comparator<Map.Entry<K, Integer>> cmp = (o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue());

    public int update(K key) {
        int r = 1;
        if (this.map.containsKey(key)) {
            Integer n = this.map.get(key);
            r = n == null ? 0 : 1 + n;
        }
        this.map.put(key, r);
        return r;
    }

    public int get(K key) {
        try {
            return this.map.get(key);
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public List<Map.Entry<K, Integer>> histogram() {
        try {
            ArrayList<Map.Entry<K, Integer>> list = new ArrayList<Map.Entry<K, Integer>>(this.map.entrySet());
            Collections.sort(list, this.cmp);
            return Collections.unmodifiableList(list);
        }
        catch (ConcurrentModificationException e) {
            return Collections.emptyList();
        }
    }

    public int getKeyCount() {
        return this.map.size();
    }

    public void reset() {
        this.map.clear();
    }
}

