/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

public final class Hex {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Hex() {
    }

    public static byte[] decode(char[] data) {
        int len = data.length;
        byte[] out = new byte[len >> 1];
        int i2 = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i2] = (byte)(f & 0xFF);
            ++i2;
        }
        return out;
    }

    public static byte[] decode(String data) {
        return Hex.decode(data.toCharArray());
    }

    public static String encode(byte[] data) {
        return new String(Hex.encode(data, true));
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        return Hex.encode(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    private static char[] encode(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i2 = 0; i2 < l; ++i2) {
            out[j++] = toDigits[(0xF0 & data[i2]) >>> 4];
            out[j++] = toDigits[0xF & data[i2]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

