/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrentz2.Torrentz2SearchPerformer;
import com.frostwire.search.torrentz2.Torrentz2SearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Torrentz2SearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(Torrentz2SearchPerformerTest.class);

    @Test
    public void torrentz2SearchTest() {
        String TEST_SEARCH_TERM = UrlUtils.encode("public domain");
        Torrentz2SearchPerformer nyaa = new Torrentz2SearchPerformer(1L, TEST_SEARCH_TERM, 5000);
        Torrentz2SearchListener torrentz2SearchListener = new Torrentz2SearchListener();
        nyaa.setListener(torrentz2SearchListener);
        try {
            nyaa.perform();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.info("Aborting test.");
            Assertions.fail(t.getMessage());
            return;
        }
        if (torrentz2SearchListener.failedTests.size() > 0) {
            Assertions.fail(torrentz2SearchListener.getFailedMessages());
        }
    }

    static class Torrentz2SearchListener
    implements SearchListener {
        final List<String> failedTests = new ArrayList<String>();

        Torrentz2SearchListener() {
        }

        @Override
        public void onResults(long token, List<? extends SearchResult> results) {
            if (results == null || results.size() == 0) {
                this.failedTests.add("No search results");
                return;
            }
            for (SearchResult searchResult : results) {
                Torrentz2SearchResult sr = (Torrentz2SearchResult)searchResult;
                LOG.info("Torrentz2SearchPerformer.SearchListener.onResults:");
                LOG.info("\t Hash: " + sr.getHash());
                LOG.info("\t Size: " + sr.getSize());
                if (StringUtils.isNullOrEmpty(sr.getDisplayName())) {
                    this.failedTests.add("getDisplayName is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getSource())) {
                    this.failedTests.add("getSource is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDetailsUrl())) {
                    this.failedTests.add("getDetailsUrl is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getFilename())) {
                    this.failedTests.add("getFilename is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getHash())) {
                    this.failedTests.add("getHash is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getTorrentUrl())) {
                    this.failedTests.add("getTorrentUrl is null or empty");
                }
                if (this.failedTests.size() <= 0) continue;
                return;
            }
        }

        @Override
        public void onError(long token, SearchError error) {
            this.failedTests.add(error.message());
        }

        @Override
        public void onStopped(long token) {
        }

        public String getFailedMessages() {
            if (this.failedTests.size() == 0) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            for (String msg : this.failedTests) {
                buffer.append(msg);
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

