/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.limetorrents.LimeTorrentsSearchPerformer;
import com.frostwire.search.limetorrents.LimeTorrentsSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import java.util.List;

public class LimeTorrentsTest {
    private static final Logger LOG = Logger.getLogger(LimeTorrentsTest.class);

    public static void main(String[] args2) {
        String TEST_SEARCH_TERM = UrlUtils.encode("foobar");
        final LimeTorrentsSearchPerformer limeTorrentsSearchPerformer = new LimeTorrentsSearchPerformer("www.limetorrents.info", 1L, TEST_SEARCH_TERM, 5000);
        limeTorrentsSearchPerformer.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                for (SearchResult searchResult : results) {
                    LimeTorrentsSearchResult sr = (LimeTorrentsSearchResult)searchResult;
                    LOG.info("\t Hash: " + sr.getHash());
                    LOG.info("\t Seeds: " + sr.getSeeds());
                }
                limeTorrentsSearchPerformer.stop();
            }

            @Override
            public void onError(long token, SearchError error) {
                System.err.println(error.message());
            }

            @Override
            public void onStopped(long token) {
            }
        });
        try {
            limeTorrentsSearchPerformer.perform();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.info("Aborting test.");
            return;
        }
        LOG.info("-done-");
    }
}

