/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.eztv.EztvSearchPerformer;
import com.frostwire.search.eztv.EztvSearchResult;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.search.SearchEngine;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class EztvSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(EztvSearchPerformerTest.class);

    @Test
    public void eztvSearchTest() {
        final ArrayList testResults = new ArrayList();
        EztvSearchPerformer searchPerformer = (EztvSearchPerformer)SearchEngine.getSearchEngineByID(SearchEngine.SearchEngineID.EZTV_ID).getPerformer(1L, "love");
        searchPerformer.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                for (SearchResult searchResult : results) {
                    EztvSearchResult esr = (EztvSearchResult)searchResult;
                    LOG.info("[EztvSearchPerformerTest] hash: " + esr.getHash());
                    LOG.info("[EztvSearchPerformerTest] fileSize: " + esr.getSize());
                    testResults.add(esr);
                }
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
            }
        });
        searchPerformer.perform();
        if (!searchPerformer.isDDOSProtectionActive()) {
            Assertions.assertFalse(testResults.isEmpty(), "[EztvSearchPerformerTest] results should not be empty");
        }
    }
}

