/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.archiveorg.ArchiveorgCrawledSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgSearchResult;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.search.SearchEngine;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArchiveorgSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(ArchiveorgSearchPerformerTest.class);

    @Test
    public void testSearch() {
        final ArrayList searchResults = new ArrayList();
        final SearchPerformer searchPerformer = SearchEngine.getSearchEngineByID(SearchEngine.SearchEngineID.ARCHIVEORG_ID).getPerformer(1L, "free book");
        searchPerformer.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                LOG.info("Results: " + results.size());
                for (SearchResult searchResult : results) {
                    if (searchResult instanceof ArchiveorgSearchResult) {
                        searchPerformer.crawl((CrawlableSearchResult)searchResult);
                        continue;
                    }
                    if (!(searchResult instanceof ArchiveorgCrawledSearchResult)) continue;
                    ArchiveorgCrawledSearchResult sr = (ArchiveorgCrawledSearchResult)searchResult;
                    searchResults.add(sr);
                    LOG.info("[ArchiveorgSearchPerformerTest] source: " + sr.getSource());
                    LOG.info("[ArchiveorgSearchPerformerTest] size: " + sr.getSize());
                    LOG.info("[ArchiveorgSearchPerformerTest] ---------------------");
                }
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
            }
        });
        searchPerformer.perform();
        Assertions.assertTrue(searchResults.size() > 0, "[ArchiveorgSearchPerformerTest] No results found");
    }
}

