/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.service;

import com.frostwire.service.ErrorCallback;
import java.io.PrintStream;

public final class ErrorService {
    private static volatile ErrorCallback _errorCallback = new PrintStreamErrorCallback(System.out);

    private ErrorService() {
    }

    public static void setErrorCallback(ErrorCallback callback) {
        _errorCallback = callback;
    }

    public static void error(Throwable problem) {
        _errorCallback.error(problem);
    }

    public static void error(Throwable problem, String detail) {
        _errorCallback.error(problem, detail);
    }

    private static class PrintStreamErrorCallback
    implements ErrorCallback {
        private final PrintStream out;

        PrintStreamErrorCallback(PrintStream out) {
            this.out = out;
        }

        @Override
        public void error(Throwable t) {
            t.printStackTrace(this.out);
            throw new RuntimeException(t.getMessage());
        }

        @Override
        public void error(Throwable t, String msg) {
            t.printStackTrace(this.out);
            this.out.println(msg);
            throw new RuntimeException(t.getMessage());
        }
    }
}

