/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.yify;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.TorrentRegexCrawlerSearchPerformer;
import com.frostwire.search.yify.YifySearchResult;
import com.frostwire.search.yify.YifyTempSearchResult;

public final class YifySearchPerformer
extends TorrentRegexCrawlerSearchPerformer<YifySearchResult> {
    public static final String SEARCH_RESULTS_REGEX = "(?is)<a class=\"movielink\" href=\"/movie/(?<itemId>[0-9]*)/(?<htmlFileName>.*?)\" itemprop=\"name\">";
    public static final String TORRENT_DETAILS_PAGE_REGEX = "(?is)<section id=\"(movie|torrent)\".*?<h1( itemprop=\"name\")?>(?<displayName>.*?)</h1>.*?<dt>Size:</dt>.*?<dd>(?<size>.*?)</dd>.*?Date:</dt>.*?(?<creationDate>[0-9]+/[0-9]+/[0-9]+.*?).*?</dd>.*?<dt>(Seeds|Seeders):</dt>.*?<dd>(?<seeds>[0-9]+).*?</dd>.*?<a href=\"(?<magnet>.*?)\" id=\"dm\" class=\"button button-default\".*?>Download Magnet</a>.*?";
    private static final int MAX_RESULTS = 21;
    private boolean isDDOSProtectionActive;

    public YifySearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 42, 21, SEARCH_RESULTS_REGEX, TORRENT_DETAILS_PAGE_REGEX);
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/search/" + encodedKeywords + "/";
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group("itemId");
        String htmlFileName = matcher.group("htmlFileName");
        return new YifyTempSearchResult(this.getDomainName(), itemId, htmlFileName);
    }

    @Override
    protected YifySearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new YifySearchResult(sr.getDetailsUrl(), matcher);
    }

    @Override
    protected boolean isValidHtml(String html) {
        this.isDDOSProtectionActive = html == null || html.contains("Cloudflare");
        return !this.isDDOSProtectionActive;
    }

    @Override
    public boolean isDDOSProtectionActive() {
        return this.isDDOSProtectionActive;
    }

    @Override
    public boolean isCrawler() {
        return true;
    }

    @Override
    protected int htmlPrefixOffset(String html) {
        int offset = html.indexOf("<div id=\"content\"");
        return offset > 0 ? offset : 0;
    }

    @Override
    protected int htmlSuffixOffset(String html) {
        int offset = html.indexOf("<section id=\"movie_bottom\">");
        return offset > 0 ? offset : html.length();
    }
}

