/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrentz2;

import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.search.torrentz2.Torrentz2SearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Torrentz2SearchPerformer
extends SimpleTorrentSearchPerformer {
    private static final Logger LOG = Logger.getLogger(Torrentz2SearchPerformer.class);
    private static Pattern pattern;
    private final String unencodedKeywords;

    public Torrentz2SearchPerformer(long token, String keywords, int timeout2) {
        super("torrentz2.nz", token, keywords, timeout2, 1, 0);
        if (pattern == null) {
            pattern = Pattern.compile("(?is)<dl><dt><a href=\".*?\" target=\"_blank\">(?<filename>.*?)</a></dt><dd><span><a href=\"(?<magnet>.*?)\"><i class=\"fa-solid fa-magnet\"></i></a></span><span title=\"\\d+\">(?<age>.*?)</span><span>(?<filesize>.*?)</span><span>(?<seeds>\\d+)</span>");
        }
        this.unencodedKeywords = keywords;
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/search?q=" + this.unencodedKeywords.replace(" ", "+");
    }

    private Torrentz2SearchResult fromMatcher(SearchMatcher matcher) {
        String filename = matcher.group("filename");
        String ageString = matcher.group("age");
        String fileSizeMagnitude = matcher.group("filesize");
        String fileSizeUnit = matcher.group("unit");
        String magnetUrl = matcher.group("magnet");
        String infoHash = UrlUtils.extractInfoHash(magnetUrl);
        String detailsURL = "https://" + this.getDomainName() + "/" + infoHash;
        int seeds = 20;
        try {
            seeds = Integer.parseInt(Objects.requireNonNull(matcher.group("seeds")), 20);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Torrentz2SearchResult(detailsURL, infoHash, filename, fileSizeMagnitude, fileSizeUnit, ageString, seeds, "tr=udp://tracker.leechers-paradise.org:6969/announce&tr=udp://tracker.coppersurfer.tk:6969/announce&tr=udp://tracker.internetwarriors.net:1337/announce&tr=udp://retracker.akado-ural.ru:80/announce&tr=udp://tracker.moeking.me:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://retracker.baikal-telecom.net:2710/announce&tr=udp://bt.dy20188.com:80/announce&tr=udp://tracker.nyaa.uk:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://amigacity.xyz:6969/announce&tr=udp://tracker.supertracker.net:1337/announce&tr=udp://tracker.cyberia.is:6969/announce&tr=udp://tracker.openbittorrent.com:80/announce&tr=udp://tracker.msm8916.com:6969/announce&tr=udp://tracker.sktorrent.net:6969/announce&");
    }

    protected List<? extends Torrentz2SearchResult> searchPage(String page) {
        boolean matcherFound;
        if (null == page || page.isEmpty()) {
            this.stopped = true;
            return Collections.emptyList();
        }
        ArrayList<Torrentz2SearchResult> results = new ArrayList<Torrentz2SearchResult>(0);
        int ffOffset = page.indexOf("Torrents");
        String pageString = page.substring(ffOffset > 0 ? ffOffset : 0);
        SearchMatcher matcher = new SearchMatcher(pattern.matcher(pageString));
        int MAX_RESULTS = 100;
        do {
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPage() has failed.\n" + t.getMessage(), t);
            }
            if (matcherFound) {
                try {
                    Torrentz2SearchResult sr = this.fromMatcher(matcher);
                    results.add(sr);
                }
                catch (Throwable t) {
                    LOG.error(t.getMessage(), t);
                }
                continue;
            }
            if (results.size() >= 5) continue;
            LOG.warn("Torrentz2SearchPerformer search matcher broken. Please notify at https://github.com/frostwire/frostwire/issues/new");
        } while (matcherFound && !this.isStopped() && results.size() <= MAX_RESULTS);
        return results;
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

