/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.ComparableTorrentJsonItem;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.search.torrent.TorrentSearchResult;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class SimpleTorrentJsonSearchPerformer<T extends ComparableTorrentJsonItem, R extends TorrentSearchResult>
extends SimpleTorrentSearchPerformer {
    private static final int DEFAULT_NUM_CRAWLS = 10;
    private final Comparator<T> itemComparator = (a, b) -> b.getSeeds() - a.getSeeds();

    private SimpleTorrentJsonSearchPerformer(String domainName, long token, String keywords, int timeout2, int pages, int numCrawls) {
        super(domainName, token, keywords, timeout2, pages, numCrawls);
    }

    public SimpleTorrentJsonSearchPerformer(String domainName, long token, String keywords, int timeout2, int pages) {
        this(domainName, token, keywords, timeout2, pages, 10);
    }

    @Override
    protected final List<? extends SearchResult> searchPage(String page) {
        LinkedList<R> result = new LinkedList<R>();
        List<T> items = this.parseJson(page);
        if (items != null) {
            items.sort(this.itemComparator);
            for (ComparableTorrentJsonItem item : items) {
                if (this.isStopped()) continue;
                R sr = this.fromItem(item);
                result.add(sr);
            }
        }
        return result;
    }

    protected abstract List<T> parseJson(String var1);

    abstract R fromItem(T var1);
}

