/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torlock;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public final class TorLockSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    public TorLockSearchResult(String domainName, String detailsUrl, SearchMatcher matcher) {
        this.detailsUrl = detailsUrl;
        this.infoHash = matcher.group("infohash") == null ? null : matcher.group("infohash").toLowerCase();
        this.filename = this.parseFileName(matcher.group("filename"), FilenameUtils.getBaseName(detailsUrl)).replaceAll("<font color=\".*?\">|</font>", "");
        this.size = this.parseSize(matcher.group("filesize"));
        this.creationTime = this.parseCreationTime(matcher.group("time"));
        this.seeds = this.parseSeeds(matcher.group("seeds"));
        this.torrentUrl = UrlUtils.buildMagnetUrl(this.infoHash, this.filename, "tr=udp://tracker.leechers-paradise.org:6969/announce&tr=udp://tracker.coppersurfer.tk:6969/announce&tr=udp://tracker.internetwarriors.net:1337/announce&tr=udp://retracker.akado-ural.ru:80/announce&tr=udp://tracker.moeking.me:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://retracker.baikal-telecom.net:2710/announce&tr=udp://bt.dy20188.com:80/announce&tr=udp://tracker.nyaa.uk:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://amigacity.xyz:6969/announce&tr=udp://tracker.supertracker.net:1337/announce&tr=udp://tracker.cyberia.is:6969/announce&tr=udp://tracker.openbittorrent.com:80/announce&tr=udp://tracker.msm8916.com:6969/announce&tr=udp://tracker.sktorrent.net:6969/announce&");
        this.displayName = HtmlManipulator.replaceHtmlEntities(FilenameUtils.getBaseName(this.filename));
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "TorLock";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private String parseFileName(String urlEncodedFileName, String fallbackName) {
        String decodedFileName = fallbackName;
        if (!StringUtils.isNullOrEmpty(urlEncodedFileName)) {
            try {
                decodedFileName = URLDecoder.decode(urlEncodedFileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            decodedFileName.replace("&amp;", "and");
        }
        return decodedFileName + ".torrent";
    }

    private int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy", Locale.US);
            result = myFormat.parse(dateString).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

