/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torlock;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torlock.TorLockSearchResult;
import com.frostwire.search.torlock.TorLockTempSearchResult;
import com.frostwire.search.torrent.TorrentRegexCrawlerSearchPerformer;

public final class TorLockSearchPerformer
extends TorrentRegexCrawlerSearchPerformer<TorLockSearchResult> {
    private static final int MAX_RESULTS = 15;
    private static final String PRELIMINARY_REGEX = "(?is)<a href=/torrent/([0-9]*?/.*?\\.html)>";
    private static final String HTML_REGEX = "(?is)<a href=\".*?/tor/(?<torrentid>.*?).torrent\".*?<dt>NAME</dt>.?<dd>(?<filename>.*?).torrent</dd>.*?<dt>INFOHASH</dt><dd.*?>(?<infohash>.*?)</dd>.*?<dt>SIZE</dt>.?<dd>(?<filesize>.*?) in.*?<dt>ADDED</dt>.?<dd>Uploaded on (?<time>.*?) by.*?<dt>SWARM</dt>.?<dd><b style=\"color:#FF5400\">(?<seeds>\\d*?)</b>";
    private boolean isDDOSProtectionActive;

    public TorLockSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 30, 15, PRELIMINARY_REGEX, HTML_REGEX);
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        String transformedKeywords = encodedKeywords.replace("%20", "-");
        return "https://" + this.getDomainName() + "/all/torrents/" + transformedKeywords + ".html";
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group(1);
        return new TorLockTempSearchResult(this.getDomainName(), itemId);
    }

    @Override
    protected int htmlPrefixOffset(String html) {
        int offset = html.indexOf("SIGN UP</a>");
        return Math.max(offset, 0);
    }

    @Override
    protected int htmlSuffixOffset(String html) {
        int offset = html.indexOf(">Description</a></li>");
        return Math.max(offset, 0);
    }

    @Override
    protected TorLockSearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new TorLockSearchResult(this.getDomainName(), sr.getDetailsUrl(), matcher);
    }

    @Override
    protected boolean isValidHtml(String html) {
        this.isDDOSProtectionActive = html == null || html.contains("Cloudflare");
        return !this.isDDOSProtectionActive;
    }

    @Override
    public boolean isDDOSProtectionActive() {
        return this.isDDOSProtectionActive;
    }

    @Override
    public boolean isCrawler() {
        return true;
    }
}

