/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.telluride;

import com.frostwire.licenses.License;
import com.frostwire.search.HttpSearchResult;
import com.frostwire.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class TellurideSearchResult
implements HttpSearchResult {
    private final String id;
    private final String title;
    private final String filename;
    private final String source;
    private final String detailsUrl;
    private final String downloadUrl;
    private final String thumbnail;
    private final long fileSize;
    private final long creationTime;

    public TellurideSearchResult(String _id, String _title, String _filename, String _source, String _detailsUrl, String _downloadUrl, String _thumbnail, long _fileSize, long _creationTime) {
        this.id = _id;
        this.title = StringUtils.removeDoubleSpaces(StringUtils.removeUnicodeCharacters(_title));
        this.filename = FilenameUtils.sanitizeFilename(_filename);
        this.source = _source;
        this.detailsUrl = _detailsUrl;
        this.downloadUrl = _downloadUrl;
        this.fileSize = _fileSize;
        this.thumbnail = _thumbnail;
        this.creationTime = _creationTime;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.title;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public License getLicense() {
        return null;
    }

    @Override
    public String getThumbnailUrl() {
        return this.thumbnail;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.fileSize;
    }
}

