/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.telluride;

import com.frostwire.search.AbstractSearchPerformer;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.telluride.TellurideAbstractListener;
import com.frostwire.search.telluride.TellurideLauncher;
import com.frostwire.search.telluride.TellurideSearchPerformerListener;
import com.frostwire.search.telluride.TellurideSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.Ssl;
import com.frostwire.util.UrlUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class TellurideSearchPerformer
extends AbstractSearchPerformer {
    private static final Logger LOG = Logger.getLogger(TellurideSearchPerformer.class);
    private static Gson gson = null;
    private static Calendar calendar = null;
    private final CountDownLatch performerLatch;
    private final String url;
    private final TellurideSearchPerformerListener performerListener;
    private final File tellurideLauncher;

    public TellurideSearchPerformer(long token, String _url, TellurideSearchPerformerListener _performerListener, File _tellurideLauncher) {
        super(token);
        if (_url.contains("instagram.com/reel")) {
            _url = _url.replace("reel/", "p/");
        }
        this.url = _url;
        this.performerListener = _performerListener;
        this.tellurideLauncher = _tellurideLauncher;
        this.performerLatch = new CountDownLatch(1);
        if (gson == null) {
            gson = new GsonBuilder().create();
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
    }

    @Override
    public void perform() {
        this.stopped = false;
        TellurideLauncher.launch(this.tellurideLauncher, this.url, null, false, true, false, new TellurideProcessListener(this));
        try {
            this.performerLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stopped = true;
    }

    @Override
    public void crawl(CrawlableSearchResult sr) {
    }

    @Override
    public boolean isCrawler() {
        return false;
    }

    public static List<TellurideSearchResult> getValidResults(String jsonMeta, Gson gson, TellurideSearchPerformerListener performerListener, long token, String debugUrl) {
        TellurideJSONResult result = gson.fromJson(jsonMeta, TellurideJSONResult.class);
        if (performerListener != null) {
            performerListener.onTellurideJSONResult(token, result);
        }
        ArrayList<TellurideSearchResult> results = new ArrayList<TellurideSearchResult>();
        if (result.formats == null) {
            LOG.info("getValidResults formats are null, no valid search results for " + debugUrl);
            return results;
        }
        int originalResultCount = result.formats.size();
        for (TellurideJSONMediaFormat format : result.formats) {
            if (format.url.contains(".m3u8") || originalResultCount > 1 && format.height != 0 && format.width > format.height && format.width < 320 || originalResultCount > 1 && format.height > format.width && format.height < 480) continue;
            Object videoFormatParenthesis = "";
            if (result.webpage_url.contains("youtu") && (TellurideSearchPerformer.noCodec(format.acodec) || TellurideSearchPerformer.noCodec(format.vcodec) && TellurideSearchPerformer.noCodec(format.acodec))) continue;
            if (!TellurideSearchPerformer.noCodec(format.acodec) && TellurideSearchPerformer.noCodec(format.vcodec)) {
                videoFormatParenthesis = "(audio)";
            } else if (!TellurideSearchPerformer.noCodec(format.vcodec)) {
                if (format.width != 0 && format.height != 0) {
                    videoFormatParenthesis = "(" + format.width + "x" + format.height + ")";
                } else if (format.width == 0 && format.height != 0) {
                    videoFormatParenthesis = "(" + format.height + "p)";
                }
            } else if (TellurideSearchPerformer.noCodec(format.acodec) && TellurideSearchPerformer.noCodec(format.vcodec) && format.height > 240) {
                videoFormatParenthesis = "(" + format.height + "p)";
            }
            LOG.info("getValidResults acodec=" + format.acodec + ", vcodec=" + format.vcodec + ", ext=" + result.ext + ", url=" + format.url);
            String domainName = UrlUtils.extractDomainName(format.url);
            if (domainName != null) {
                Ssl.addValidDomain(domainName);
            }
            LOG.info("TellurideSearchPerformer.getValidResults format.url added: " + format.url);
            results.add(new TellurideSearchResult(result.id, (String)videoFormatParenthesis + " " + result.title, result.title + " " + (String)videoFormatParenthesis + "." + format.ext, "Cloud:" + result.extractor, result.webpage_url, format.url, result.thumbnail, format.filesize, result.upload_date == null ? calendar.getTimeInMillis() : TellurideSearchPerformer.dateStringToTimestamp(result.upload_date)));
        }
        return results;
    }

    private static long dateStringToTimestamp(String YYYY_MM_DD) {
        int YEAR = Integer.parseInt(YYYY_MM_DD.substring(0, 4));
        int MONTH = Integer.parseInt(YYYY_MM_DD.substring(4, 6));
        int DATE = Integer.parseInt(YYYY_MM_DD.substring(6));
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.set(1, YEAR);
        calendar.set(2, MONTH - 1);
        calendar.set(5, DATE);
        return calendar.getTimeInMillis();
    }

    private void onMeta(String json) {
        List<TellurideSearchResult> results = TellurideSearchPerformer.getValidResults(json, gson, this.performerListener, this.getToken(), this.url);
        this.onResults(results);
        if (this.performerListener != null) {
            this.performerListener.onSearchResults(this.getToken(), results);
        }
        this.performerLatch.countDown();
    }

    private void onError(String errorMessage) {
        if (this.performerListener != null) {
            this.performerListener.onError(this.getToken(), errorMessage);
        }
        this.performerLatch.countDown();
    }

    private static boolean noCodec(String codec) {
        return codec == null || "none".equals(codec);
    }

    private static class TellurideProcessListener
    extends TellurideAbstractListener {
        private final TellurideSearchPerformer performer;

        public TellurideProcessListener(TellurideSearchPerformer performer) {
            this.performer = performer;
        }

        @Override
        public void onMeta(String json) {
            this.performer.onMeta(json);
        }

        @Override
        public void onError(String errorMessage) {
            this.performer.onError(errorMessage);
        }
    }

    public static class TellurideJSONResult {
        public String id;
        public String ext;
        public String title;
        public String extractor;
        public String webpage_url;
        public String upload_date;
        public String thumbnail;
        public List<TellurideJSONMediaFormat> formats;
    }

    public static class TellurideJSONMediaFormat {
        public String format_id;
        public String url;
        public String ext;
        public String acodec;
        public long filesize;
        public String vcodec;
        public int height;
        public int width;
    }
}

