/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.soundcloud;

import com.frostwire.search.soundcloud.SoundcloudMedia;
import com.frostwire.search.soundcloud.SoundcloudTranscodings;
import com.frostwire.search.soundcloud.SoundcloudUser;

final class SoundcloudItem {
    public int id;
    public SoundcloudUser user;
    public String uri;
    public int duration;
    public String permalink;
    public String title;
    public String permalink_url;
    public String artwork_url;
    public String stream_url;
    public String created_at;
    public boolean downloadable;
    public String download_url;
    public SoundcloudMedia media;

    SoundcloudItem() {
    }

    boolean isValidSearchResult() {
        return this.isValidSearchResult(false);
    }

    boolean isValidSearchResult(boolean fromPastedUrl) {
        if (fromPastedUrl) {
            return this.hasProgressiveFormat();
        }
        return this.downloadable && this.hasProgressiveFormat();
    }

    boolean hasProgressiveFormat() {
        if (this.media == null) {
            return false;
        }
        for (SoundcloudTranscodings transcodings : this.media.transcodings) {
            if (!"progressive".equals(transcodings.format.protocol)) continue;
            return true;
        }
        return false;
    }

    String getProgressiveFormatJSONFetcherURL() {
        if (this.media == null) {
            return null;
        }
        for (SoundcloudTranscodings transcodings : this.media.transcodings) {
            if (!"progressive".equals(transcodings.format.protocol)) continue;
            return transcodings.url;
        }
        return null;
    }
}

