/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.one337x;

import com.frostwire.search.PerformersHelper;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import org.apache.commons.io.FilenameUtils;

public final class One337xSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;
    private final String magnetUrl;

    public One337xSearchResult(String detailsUrl, String displayName, SearchMatcher matcher) {
        this.detailsUrl = detailsUrl;
        this.displayName = displayName;
        this.size = this.parseSize(matcher.group("size"));
        this.creationTime = this.parseCreationTime(matcher.group("creationDate"));
        this.seeds = One337xSearchResult.parseSeeds(matcher.group("seeds"));
        this.magnetUrl = matcher.group("magnet");
        this.filename = One337xSearchResult.buildFileName(detailsUrl);
        this.infoHash = PerformersHelper.parseInfoHash(this.magnetUrl);
    }

    private static String buildFileName(String detailsUrl) {
        return FilenameUtils.getBaseName(detailsUrl) + ".torrent";
    }

    private static int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getTorrentUrl() {
        return this.magnetUrl;
    }

    @Override
    public String getSource() {
        return "1337x";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            String[] ds = dateString.split(" ");
            if (ds[1].contains("hour")) {
                try {
                    int hours = Integer.parseInt(ds[0]);
                    return result - (long)(hours * 60 * 60) * 1000L;
                }
                catch (Exception hours) {
                    // empty catch block
                }
            }
            if (ds[1].contains("year")) {
                try {
                    int years = Integer.parseInt(ds[0]);
                    return result - (long)years * 365L * 24L * 60L * 60L * 1000L;
                }
                catch (Exception years) {
                    // empty catch block
                }
            }
            if (ds[1].contains("month")) {
                try {
                    int months = Integer.parseInt(ds[0]);
                    return result - (long)months * 31L * 24L * 60L * 60L * 1000L;
                }
                catch (Exception months) {
                    // empty catch block
                }
            }
            if (ds[1].contains("minute")) {
                try {
                    int minutes = Integer.parseInt(ds[0]);
                    return result - (long)minutes * 60L * 1000L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return result;
        }
    }
}

